# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper
import ProductAttributes
import Cell

def registerSupervisorColdBoot( entityManager ):
   sh = StageSysdbHelper.StageHelper( entityManager, 'boot' )
   sh.applicationIs( "Supervisor Cold boot" )
   sh.continueOnTimeoutIs( True )

   sh.registerStageDependency( "CriticalAgent", [] )
   sh.registerStage( "Aaa", "CriticalAgent", complete=True )
   sh.registerStage( "SuperServer", "CriticalAgent", complete=True )
   sh.registerStage( "FastClidHelper-Cli", "CriticalAgent", complete=True )
   sh.registerStage( "CleanConfigAgent", "CriticalAgent", complete=True )
   sh.registerStage( "PhyEthtool", "CriticalAgent", complete=True )

   sh.registerStageDependency( "Fru-Plugins", [] )
   sh.registerStage( "Fru", "Fru-Plugins", timeout=60 )

   sh.registerStageDependency( "PrimaryAgent", [ "Fru-Plugins" ] )
   sh.registerStage( "Scd", "PrimaryAgent" , completeNotRunnable=True )
   sh.registerStage( "ReloadCauseAgent", "PrimaryAgent", complete=True )
   sh.registerStage( "PlutoSmbus", "PrimaryAgent", complete=True )
   sh.registerStage( "PLSmbusMediator", "PrimaryAgent", complete=True )
   sh.registerStage( "PLSystem", "PrimaryAgent", completeNotRunnable=True )
   sh.registerStage( "Smbus", "PrimaryAgent" )
   sh.registerStage( "PciBus", "PrimaryAgent", timeout=180 )

   sh.registerStageDependency( "HardwareAgent", [ "PrimaryAgent" ] )
   sh.registerStage( "StrataCentral", "HardwareAgent", timeout=120 )
   sh.registerStage( "StrataL2", "HardwareAgent", complete=True )
   sh.registerStage( "StrataL3", "HardwareAgent", complete=True )
   sh.registerStage( "StrataLag", "HardwareAgent", complete=True )
   sh.registerStage( "StrataMirror", "HardwareAgent", complete=True )
   sh.registerStage( "StrataVlanTopo", "HardwareAgent", complete=True )
   sh.registerStage( "AsicResourceMgr", "HardwareAgent", complete=True )

   # In MLAG configurations, some interfaces are errdisabled with "mlagissu" cause
   # during reload-delay. Need to make sure that the errdisable status is propagated
   # to interface config before the forwarding agent performs layer 1 init.

   # NOTE: ErrdisableCauseStatusUpdate needs to depend on
   # ConfigAgent/Fru-Plugins to guarantee that all
   # EthPhyIntfConfig(Desc) objects have been processed. See BUG192957
   # for more details.
   sh.registerStageDependency( "ErrdisableCauseStatusUpdate", [ "Fru-Plugins" ] )
   sh.registerStage( "Mlag", "ErrdisableCauseStatusUpdate",
                     completeNotRunnable=True, timeout=60 )
   # WARNING: Do not add dependencies on PhyInitAllowed.
   # StrataCentral expands Strata events into Strata-<slice>, which each slice then
   # completes. On a modular box, there are no guarntees that all slices are expanded
   # into PhyInitAllowed before the stage completes. I.e. the expanded slices
   # complete all events in PhyInitAllowed stage before new slices are added.
   # Therefore, when PhyInitAllowed completes during cold boot, it is not guaranteed
   # that all slices completed it. Here, it is simply used to gate L1 init until
   # ErrdisableStatusUpdate completes.
   sh.registerStageDependency( "ErrdisableStatusUpdate",
                               [ "ErrdisableCauseStatusUpdate" ] )
   sh.registerStage( "Ebra", "ErrdisableStatusUpdate", timeout=180 )
   sh.registerStageDependency( "PhyInitAllowed", [ "ErrdisableStatusUpdate" ] )
   sh.registerStage( "Strata", "PhyInitAllowed", complete=True, timeout=300 )

   # if this system supports asu, add Strata-FixedSystem to stages
   if ( ProductAttributes.productAttributes().productAttributes.isSingleChip and
        not ProductAttributes.productAttributes().productAttributes.hasSwitchcard ):
      sh.registerStage( "Strata-FixedSystem", "HardwareAgent", complete=True )

   sh.registerStage( "PowerFuse", "HardwareAgent", complete=True )
   sh.registerStage( "NorCalCard", "HardwareAgent", complete=True )
   sh.registerStage( "ModularSystem", "HardwareAgent", complete=True )
   if Cell.electionMgrSupported():
      sh.registerStage( "ElectionMgr", "HardwareAgent", complete=True )
   sh.registerStage( "CpuComplex", "HardwareAgent", complete=True )
   sh.registerStage( "PowerSupplyDetector", "HardwareAgent", complete=True )
   sh.registerStage( "PowerManager", "HardwareAgent", complete=True )
   sh.registerStage( "Thermostat", "HardwareAgent", complete=True )
   sh.registerStage( "FanDetector", "HardwareAgent", complete=True )
   sh.registerStage( "PsocFanController", "HardwareAgent", complete=True )
   sh.registerStage( "StandbyCpld", "HardwareAgent", complete=True )
   sh.registerStage( "Adt7462", "HardwareAgent", complete=True )
   sh.registerStage( "Lm73", "HardwareAgent", complete=True )
   sh.registerStage( "Lm95234", "HardwareAgent", complete=True )

   sh.registerStage( "Ucd9012", "HardwareAgent", complete=True )
   sh.registerStage( "Ucd9012-system", "HardwareAgent", complete=True )

   sh.registerStage( "Si5327", "HardwareAgent", complete=True )
   sh.registerStage( "MicrosemiAgent", "HardwareAgent", complete=True )
   sh.registerStage( "PlxPcie", "HardwareAgent", complete=True )
   sh.registerStage( "PlxPcie-system", "HardwareAgent", complete=True )
   sh.registerStage( "Ds125Br", "HardwareAgent", complete=True )

   sh.registerStage( "Max6697", "HardwareAgent", complete=True )
   sh.registerStage( "Max6697-system", "HardwareAgent", complete=True )
   sh.registerStage( "Max6581", "HardwareAgent", complete=True )
   sh.registerStage( "Max6581-system", "HardwareAgent", complete=True )

   sh.registerStage( "Max6658", "HardwareAgent", complete=True )
   sh.registerStage( "Max6658-system", "HardwareAgent", complete=True )
   sh.registerStage( "Pca9555", "HardwareAgent", complete=True )
   sh.registerStage( "GpioLed", "HardwareAgent", complete=True )
   sh.registerStage( "Pmbus", "HardwareAgent", complete=True )
   sh.registerStage( "EpilAgent", "HardwareAgent", complete=True )
   sh.registerStage( "Ecb", "HardwareAgent", complete=True )
   sh.registerStage( "Ecb-system", "HardwareAgent", complete=True )

   # Adding 'InfrastructureAgent' stage before NetworkAgent stage. As of now
   # MaintenanceMode and Ira are the only participating agent. This is required as
   # MaintenanceMode agent needs to come up before Rib during stagedBoot
   # introduced for strata-fixed systems.
   sh.registerStageDependency( "InfrastructureAgent", [] )
   sh.registerStage( "MaintenanceMode", "InfrastructureAgent", 
                     completeNotRunnable=True, timeout=120 )
   sh.registerStage( "Ira", "InfrastructureAgent", timeout=120 )

   # Adding 'BfdStatusUpdate' stage before NetworkAgent stage. Lag depends on
   # Bfd and Bfd is producing certain status output (i.e. statusIntf::perLink)
   # for Lag to consume.
   sh.registerStageDependency( "BfdStatusUpdate", [] )
   sh.registerStage( "Bfd", "BfdStatusUpdate", timeout=60 )

   sh.registerStageDependency( "SecondaryHardwareAgent", [ "HardwareAgent" ] )

   # if this system supports asu, add Strata-FixedSystem to stages
   if ( ProductAttributes.productAttributes().productAttributes.isSingleChip and
        not ProductAttributes.productAttributes().productAttributes.hasSwitchcard ):
      sh.registerStage( "Strata-FixedSystem", "SecondaryHardwareAgent" )

   sh.registerStage( "StrataCentral", "SecondaryHardwareAgent" )
   sh.registerStage( "Strata", "SecondaryHardwareAgent", complete=True, timeout=300 )
   sh.registerStage( "Xcvr", "SecondaryHardwareAgent", complete=True,
                     timeout=120 )
   sh.registerStage( "XcvrAgent", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "ScdSlice", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "SmbusSlice", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "FpgaAgent", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "FpgaAgentSlice", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "Babbage", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "PhyIsland", "SecondaryHardwareAgent", complete=True )

   sh.registerStageDependency( "NetworkAgent", [ "HardwareAgent",
                                                 "InfrastructureAgent",
                                                 "BfdStatusUpdate"
                                               ] )
   sh.registerStage( "Stp", "NetworkAgent", complete=True )
   sh.registerStage( "StpTopology", "NetworkAgent", complete=True )
   sh.registerStage( "StpTxRx", "NetworkAgent", complete=True )
   sh.registerStage( "TopoAgent", "NetworkAgent", complete=True )
   sh.registerStage( "Arp", "NetworkAgent", complete=True )
   sh.registerStage( "Acl", "NetworkAgent", complete=True )
   sh.registerStage( "PortSec", "NetworkAgent", complete=True )
   sh.registerStage( "Qos", "NetworkAgent", complete=True )

   sh.registerStage( "Ebra", "NetworkAgent", timeout=60 )
   sh.registerStage( "Lag", "NetworkAgent", timeout=60 )
   sh.registerStage( "LacpTxAgent", "NetworkAgent", timeout=60 )
   sh.registerStage( "Rib", "NetworkAgent", timeout=200,
                     completeNotRunnable=True )
   sh.registerStage( "Rib-vrf", "NetworkAgent", timeout=200,
                     completeNotRunnable=True )
   sh.registerStage( "Ospf", "NetworkAgent", timeout=200,
                     completeNotRunnable=True )
   sh.registerStage( "Ospf-vrf", "NetworkAgent", timeout=120,
                     completeNotRunnable=True )
   sh.registerStage( "Ospf3", "NetworkAgent", timeout=200,
                     completeNotRunnable=True )
   sh.registerStage( "Ospf3-vrf", "NetworkAgent", timeout=120,
                     completeNotRunnable=True )
   sh.registerStage( "Isis", "NetworkAgent", timeout=200,
                     completeNotRunnable=True )
   sh.registerStage( "Isis-vrf", "NetworkAgent", timeout=120,
                     completeNotRunnable=True )
   sh.registerStage( "Rip", "NetworkAgent", complete=True )
   sh.registerStage( "Rip-vrf", "NetworkAgent", complete=True )
   sh.registerStage( "KernelFib", "NetworkAgent", complete=True )
   sh.registerStage( "Fhrp", "NetworkAgent", complete=True )
   sh.registerStage( "KernelNetworkInfo", "NetworkAgent", complete=True )
   sh.registerStage( "MlagTunnel", "NetworkAgent", complete=True )
   sh.registerStage( "IgmpSnooping", "NetworkAgent", complete=True )
   sh.registerStage( "L2Rib", "NetworkAgent", complete=True )
   sh.registerStage( "Lldp", "NetworkAgent", complete=True )
   sh.registerStage( "McastCommon", "NetworkAgent", complete=True )
   sh.registerStage( "McastCommon6", "NetworkAgent", complete=True )
   sh.registerStage( "Snmp", "NetworkAgent", complete=True )
   sh.registerStage( "Tunnel", "NetworkAgent", complete=True )

   sh.registerStageDependency( "HardwareAgentComplete",
                               [ "SecondaryHardwareAgent" ] )

   # Strata already defers update by 60 seconds, hence more for larger system
   sh.registerStage( "Strata", "HardwareAgentComplete", complete=True, timeout=600 )

