# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper

# Register stage dependencies for maintExit stage class
def registerMaintExit( entityMgr ):
   sh = StageSysdbHelper.StageHelper( entityMgr, 'maintExit' )
   sh.registerStageClass()
   sh.registerStage( 'EventMgr', 'begin', [], timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'before_ratemon', [ 'begin' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'MaintenanceMode', 'ratemon', [ 'before_ratemon' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'after_ratemon', [ 'ratemon' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'before_linkdown', [ 'after_ratemon' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'Mlag', 'linkdown', [ 'before_linkdown' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'after_linkdown', [ 'linkdown' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'before_bgp', [ 'after_linkdown' ],
                     timeout=Tac.endOfTime )

   # Either Rib or Bgp agent runs. Register them both here. Launcher will
   # autocomplete the event for the agent that isn't runnable.
   sh.registerStage( 'Bgp', 'bgp', [ 'before_bgp' ], timeout=Tac.endOfTime )
   # Rib-vrf-<vrfName> registrations happen in the respective agents
   sh.registerStage( 'Rib', 'bgp', [ 'before_bgp' ], timeout=Tac.endOfTime )

   sh.registerStage( 'EventMgr', 'after_bgp', [ 'bgp' ], timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'before_mlag', [ 'after_bgp' ],
                     timeout=Tac.endOfTime )
   sh.registerStage( 'Mlag', 'mlag', [ 'before_mlag' ], timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'after_mlag', [ 'mlag' ], timeout=Tac.endOfTime )
   sh.registerStage( 'EventMgr', 'end', [ 'after_mlag' ], timeout=Tac.endOfTime )
   sh.initializedIs( True )

