# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import StageSysdbHelper
from StageGraphUtil import registerLinecardSliceStage
from StageGraphUtil import getPlatformType

traceHandle = Tracing.Handle( 'StageGraphs' )
t0 = traceHandle.trace0

def registerAsuShutdown( entityManager ):
   sh = StageSysdbHelper.StageHelper( entityManager, 'shutdown' )
   sh.applicationIs( "Asu Shutdown" )

   platform = getPlatformType()
   t0( "registerAsuShutdown platform:", platform )

   sh.registerStageDependency( "MlagShutdown", [] )
   sh.registerStage( "Mlag", "MlagShutdown", timeout=60, completeNotRunnable=True )

   sh.registerStageDependency( "ErrdisableIntfsConfig", [ "MlagShutdown" ] )
   sh.registerStage( "Ebra", "ErrdisableIntfsConfig", timeout=180 )

   sh.registerStageDependency( "NetworkAgentShutdown", [ "ErrdisableIntfsConfig" ] )
   sh.registerStage( "Arp", "NetworkAgentShutdown", timeout=30 )
   sh.registerStage( "Bmp", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True )
   sh.registerStage( "Fhrp", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True )
   sh.registerStage( "Ipv6RouterAdvt", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True ) 
   sh.registerStage( "Rib", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True )
   sh.registerStage( "Ospf", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True )
   sh.registerStage( "Ospf3", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True )
   sh.registerStage( "Isis", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True )
   sh.registerStage( "Bfd", "NetworkAgentShutdown", timeout=30, critical=False )
   sh.registerStage( "Bgp", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True )
   sh.registerStage( "Pim", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True )
   sh.registerStage( "PimBsr", "NetworkAgentShutdown", timeout=30,
                     completeNotRunnable=True )

   sh.registerStageDependency( "PlatformBfdShutdown", [ "NetworkAgentShutdown" ] )
   sh.registerStage( "StrataBfd", "PlatformBfdShutdown", timeout=30,
                     completeNotRunnable=True )
   sh.registerStage( "SandBfd", "PlatformBfdShutdown", timeout=30,
                     completeNotRunnable=True )

   lacpTxAgentDep = "NetworkAgentShutdown"
   sh.registerStageDependency( "LacpPacketsConfig", [ lacpTxAgentDep ] )
   sh.registerStage( "LacpTxAgent", "LacpPacketsConfig", timeout=30 )

   sh.registerStageDependency( "VxlanArpShutdown", [ "NetworkAgentShutdown" ] )
   

   if platform == "strata":
      sh.registerStageDependency( "DmaDriverShutdown", [ "LacpPacketsConfig" ] )
      registerLinecardSliceStage( sh, "DmaDriverShutdown", timeout=30 )
      registerLinecardSliceStage( sh, "VxlanArpShutdown", timeout=30 )
      sh.registerStage( "StrataL2", "DmaDriverShutdown", timeout=30 )

      sh.registerStageDependency( "CountersShutdown", [] )
      sh.registerStage( "StrataCounters", "CountersShutdown", timeout=60,
                        completeNotRunnable=True )


