# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper
import Tracing
from StageGraphUtil import registerAllSliceStage
from StageGraphUtil import registerLinecardSliceStage
from StageGraphUtil import registerPhyIslandStage

traceHandle = Tracing.Handle( 'StageGraphs' )
t0 = traceHandle.trace0

def registerAsuHitlessBootStrata( entityManager ):

   sh = StageSysdbHelper.StageHelper( entityManager, 'boot' )
   sh.applicationIs( "Asu Hitless boot" )
   sh.stageTimeoutIsFatalIs( True )

   sh.registerStageDependency( "CriticalAgent", [] )
   sh.registerStage( "Aaa", "CriticalAgent", complete=True )
   sh.registerStage( "SuperServer", "CriticalAgent", complete=True )
   sh.registerStage( "FastClidHelper-Cli", "CriticalAgent", complete=True )
   sh.registerStage( "CleanConfigAgent", "CriticalAgent", complete=True )
   sh.registerStage( "PhyEthtool", "CriticalAgent", complete=True )
   # MaintenanceMode is started to set qualPath for Rib/ArBgp
   sh.registerStage( "MaintenanceMode", "CriticalAgent", complete=True )

   # Adding 'InfrastructureAgent' stage before NetworkAgent stage. As of now
   # Ira is the only participating agent. This is required as Ira agent needs to
   # set the qualpath as to whether which routing agents are to run
   sh.registerStageDependency( "InfrastructureAgent", [] )
   sh.registerStage( "Ira", "InfrastructureAgent", timeout=60 )

   sh.registerStageDependency( "NetworkAgent", [ 'InfrastructureAgent' ] )
   sh.registerStage( "StpTopology", "NetworkAgent", complete=True )
   sh.registerStage( "TopoAgent", "NetworkAgent", complete=True )
   sh.registerStage( "Arp", "NetworkAgent", complete=True )
   sh.registerStage( "Acl", "NetworkAgent", complete=True )
   sh.registerStage( "PortSec", "NetworkAgent", complete=True )
   sh.registerStage( "KernelMfib", "NetworkAgent", complete=True )
   sh.registerStage( "KernelFib", "NetworkAgent", complete=True )
   sh.registerStage( "KernelNetworkInfo", "NetworkAgent", complete=True )
   sh.registerStage( "Lag", "NetworkAgent" )
   sh.registerStage( "Rib", "NetworkAgent", timeout=120 )
   sh.registerStage( "Rib-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf3", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf3-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Isis", "NetworkAgent", timeout=120 )
   sh.registerStage( "Isis-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "IpRib", "NetworkAgent", timeout=120 )
   sh.registerStage( "ConnectedRoute", "NetworkAgent", timeout=120 )
   sh.registerStage( "StaticRoute", "NetworkAgent", timeout=120 )
   sh.registerStage( "RouteInput", "NetworkAgent", timeout=120 )
   sh.registerStage( "Bgp", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ipv6RouterAdvt", "NetworkAgent", complete=True )
   sh.registerStage( "Pim", "NetworkAgent", complete=True )
   sh.registerStage( "Pimsm", "NetworkAgent", complete=True )
   sh.registerStage( "PimReg", "NetworkAgent", complete=True )
   sh.registerStage( "PimBsr", "NetworkAgent", complete=True )
   sh.registerStage( "PimBidir", "NetworkAgent", complete=True )
   sh.registerStage( "PimBidirDf", "NetworkAgent", complete=True )
   sh.registerStage( "Igmp", "NetworkAgent", complete=True )
   sh.registerStage( "Msdp", "NetworkAgent", complete=True )
   sh.registerStage( "McastCommon", "NetworkAgent", complete=True )
   sh.registerStage( "IgmpSnooping", "NetworkAgent", complete=True )
   sh.registerStage( "DhcpRelay", "NetworkAgent", complete=True )
   sh.registerStage( "Fhrp", "NetworkAgent", complete=True )

   sh.registerStageDependency( "LaunchConfigUpdate", [] )
   sh.registerStage( "StrataCentral", "LaunchConfigUpdate", timeout=60 )

   sh.registerStageDependency( "Fru-Plugins", [] )
   sh.registerStage( "Fru", "Fru-Plugins", timeout=60 )

   sh.registerStageDependency( "PrimaryAgent", [ "Fru-Plugins" ] )
   sh.registerStage( "Scd", "PrimaryAgent" )
   sh.registerStage( "ReloadCauseAgent", "PrimaryAgent", complete=True )
   sh.registerStage( "PlutoSmbus", "PrimaryAgent", complete=True )
   sh.registerStage( "PLSmbusMediator", "PrimaryAgent", complete=True )
   sh.registerStage( "PLSystem", "PrimaryAgent" )
   sh.registerStage( "Smbus", "PrimaryAgent" )
   sh.registerStage( "PciBus", "PrimaryAgent", timeout=300 )

   sh.registerStageDependency( "LagIntfStatusReady", [ "LaunchConfigUpdate" ] )
   sh.registerStage( "Lag", "LagIntfStatusReady", timeout=30 )

   sh.registerStageDependency( "FeatureAgent", [ "LaunchConfigUpdate" ] )
   sh.registerStage( "StrataL2", "FeatureAgent" )
   sh.registerStage( "StrataL3", "FeatureAgent" )
   sh.registerStage( "StrataLag", "FeatureAgent" )
   sh.registerStage( "StrataVlanTopo", "FeatureAgent", timeout=300 )
   sh.registerStage( "StrataMirror", "FeatureAgent" )

   sh.registerStageDependency( "XcvrWarm", [ "PrimaryAgent" ] )
   sh.registerStage( "Xcvr", "XcvrWarm", timeout=60 )
   sh.registerStage( "PhyIsland", "XcvrWarm", complete=True )
   registerPhyIslandStage( sh, "XcvrWarm" )

   sh.registerStageDependency( "SecondaryHardwareAgent",
                               [ "XcvrWarm", "LaunchConfigUpdate", "PrimaryAgent" ] )
   sh.registerStage( "Strata", "SecondaryHardwareAgent", complete=True,
                     timeout=120 )
   registerAllSliceStage( sh, "SecondaryHardwareAgent" )

   sh.registerStageDependency( "ErrdisableStatusUpdate", [ "SecondaryHardwareAgent",
                                                           "Fru-Plugins",
                                                           "LagIntfStatusReady" ] )
   sh.registerStage( "Ebra", "ErrdisableStatusUpdate", timeout=60 )

   sh.registerStageDependency( "ModInfoUpdate", [ "LaunchConfigUpdate",
                                                  "SecondaryHardwareAgent" ] )
   sh.registerStage( "StrataCentral", "ModInfoUpdate", timeout=120 )

   # Qos should be dependent on Ebra for bridging/config/switchIntfConfig. Also,
   # Forwarding agents should start only after Qos has completed publishing info
   # into qos/status
   sh.registerStageDependency( "QosStatusUpdate", [ "ErrdisableStatusUpdate" ] )
   sh.registerStage( "Qos", "QosStatusUpdate", timeout=60 )

   sh.registerStageDependency( "StrataMmuReconcile", [ "SecondaryHardwareAgent",
                                                       "QosStatusUpdate" ] )
   sh.registerStage( "Strata", "StrataMmuReconcile", complete=True,
                     timeout=120 )
   registerLinecardSliceStage( sh, "StrataMmuReconcile" )

   sh.registerStageDependency( "LinkStatusUpdate", [ "ErrdisableStatusUpdate",
                                                     "StrataMmuReconcile" ] )
   sh.registerStage( "Strata", "LinkStatusUpdate", complete=True,
                     timeout=120 )
   registerLinecardSliceStage( sh, "LinkStatusUpdate" )
   
   # Dot1x agent depends on Ebra for bridging/config/switchIntfConfig and Ira
   # for Ira-IpStatus-deps-include. Also wait till linkStatus is known
   # before starting Dot1x.
   sh.registerStageDependency( "Dot1xStatusReady", [ "LinkStatusUpdate",
                                                     "NetworkAgent" ] )
   sh.registerStage( "Dot1x", "Dot1xStatusReady", timeout=120 )

   # Start Bfd agent before Lag enters LagStatusUpdate stage. Wait till
   # linkStatus is known before starting Bfd.
   sh.registerStageDependency( "BfdStatusUpdate", [
                               "LinkStatusUpdate", "FeatureAgent" ] )
   sh.registerStage( "Bfd", "BfdStatusUpdate", timeout=60 )

   sh.registerStageDependency( "PlatformBfdStatusUpdate", [ "BfdStatusUpdate" ] )
   sh.registerStage( "StrataBfd", "PlatformBfdStatusUpdate", complete=True )

   # Lag status reconcile can only happen after Lag agent is started and
   # platform agent publish HW Lag groups under hardware/lag/input/config and
   # also updated link speed
   sh.registerStageDependency( "LagStatusReconcile",
         [ "NetworkAgent", "SecondaryHardwareAgent", "Fru-Plugins",
           "LinkStatusUpdate", "LagIntfStatusReady" ] )
   sh.registerStage( "Lag", "LagStatusReconcile", timeout=30 )

   sh.registerStageDependency( "HwLagStatusReconcile",
      [ "ModInfoUpdate", "LinkStatusUpdate", "LagStatusReconcile", "FeatureAgent" ] )
   sh.registerStage( "StrataLag", "HwLagStatusReconcile", timeout=60 )

   sh.registerStageDependency( "PStoreRestore", [
                               "FeatureAgent" ] )
   sh.registerStage( "Mlag", "PStoreRestore", timeout=60 )

   sh.registerStageDependency( "LagStatusUpdate",
                                 [ "HwLagStatusReconcile",
                                   "BfdStatusUpdate" ] )
   sh.registerStage( "Lag", "LagStatusUpdate", timeout=60 )

   # Start BridgeIdUpdate after Lag Agent finishes updating the EthLagIntfStatus
   # for port-channel, so that peer-link can come up for Mlag to be formed
   # This stage is run only when Mlag is configured. On non-mlag switch,
   # BridgeIdUpdate will be autoCompleted by Launcher.
   sh.registerStageDependency( "BridgeIdUpdate", [
                               "LagStatusUpdate", "PStoreRestore" ] )
   # Start MlagTunnel in BridgeIdUpdate stage since it creates the 'mlag_hb' device
   # which is needed by Mlag to do PeerMounting successfully
   sh.registerStage( "MlagTunnel", "BridgeIdUpdate", complete=True )
   sh.registerStage( "Mlag", "BridgeIdUpdate", timeout=60 )

   # Start SecondaryNetworkAgent with Stp after BridgeIdUpdate, so that Mlag can
   # override Stp and prevent Stp to start with local BridgeId and there
   # not cause any churn in the port states when the STP BridgeId changes.
   sh.registerStageDependency( "SecondaryNetworkAgent", [ "BridgeIdUpdate" ] )
   sh.registerStage( "StpTxRx", "SecondaryNetworkAgent", complete=True )
   sh.registerStage( "Stp", "SecondaryNetworkAgent", complete=True )

   # Start LacpTxAgent after Lag agent finishes its initialization to prevent
   # sending inconsistent LACP state to the partner
   sh.registerStageDependency( "LacpTxStatusUpdate", [ "LagStatusUpdate" ] )
   sh.registerStage( "LacpTxAgent", "LacpTxStatusUpdate", complete=True )

   sh.registerStageDependency( "StrataLagStatusUpdate",
                               [ "LagStatusUpdate", "HwLagStatusReconcile" ] )
   sh.registerStage( "StrataLag", "StrataLagStatusUpdate", timeout=30 )

   sh.registerStageDependency( "VlanIntfOperStatusUpdate", [ "StrataLagStatusUpdate",
                                                             "Dot1xStatusReady" ] )
   sh.registerStage( "Ebra", "VlanIntfOperStatusUpdate", timeout=30 )

   sh.registerStageDependency( "EbraStatusUpdate", [ "VlanIntfOperStatusUpdate" ] )
   sh.registerStage( "Ebra", "EbraStatusUpdate", timeout=120 )

   # Vxlan agent update
   sh.registerStageDependency( "VxlanConfigUpdate", [ "EbraStatusUpdate" ] )
   sh.registerStage( "Vxlan", "VxlanConfigUpdate", timeout=60 )

   # Start VxanSwFwd agent
   sh.registerStageDependency( "VxlanSwFwdStatusUpdate", [ "VxlanConfigUpdate" ] )
   sh.registerStage( "VxlanSwFwd", "VxlanSwFwdStatusUpdate", complete=True )

   # PI Mirroring is dependent on LinkStatusUpdate being published.
   sh.registerStageDependency( "MirroringHwConfigUpdate", [ "LinkStatusUpdate" ] )
   sh.registerStage( "Mirroring", "MirroringHwConfigUpdate", timeout=60 )

   # StrataVlanTopo depends on TopoConfig creation for BridgingTopoInstUpdate
   sh.registerStageDependency( "BridgingTopoConfigCreate",
                               [ "NetworkAgent", "FeatureAgent" ] )
   sh.registerStage( "StpTopology", "BridgingTopoConfigCreate", timeout=60 )

   sh.registerStageDependency( "BridgingTopoInstUpdate",
                               [ "ModInfoUpdate", "EbraStatusUpdate",
                                 "StrataLagStatusUpdate",
                                 "BridgingTopoConfigCreate" ] )
   sh.registerStage( "StrataVlanTopo", "BridgingTopoInstUpdate", timeout=120 )

   sh.registerStageDependency( "BridgingTopoStatusUpdate",
                               [ "BridgingTopoInstUpdate" ] )
   sh.registerStage( "TopoAgent", "BridgingTopoStatusUpdate", timeout=60 )

   sh.registerStageDependency( "BridgingTopoConfigUpdate",
                               [ "SecondaryNetworkAgent",
                                 "BridgingTopoStatusUpdate" ] )
   sh.registerStage( "StpTopology", "BridgingTopoConfigUpdate", timeout=60 )

   sh.registerStageDependency( "VxlanConfigReconcile",
                               [ "ModInfoUpdate",
                                 "VxlanConfigUpdate" ] )

   sh.registerStage( "StrataL3", "VxlanConfigReconcile", complete=True, timeout=60 )

   sh.registerStageDependency( "StrataVxlanVirtualPortListUpdate",
                               [ "ModInfoUpdate",
                                 "HwLagStatusReconcile" ] )
   sh.registerStage( "StrataL3", "StrataVxlanVirtualPortListUpdate", timeout=60 )


   sh.registerStageDependency( "StrataVxlanVirtualPortListReconcile",
                                  [ "ModInfoUpdate",
                                    "StrataVxlanVirtualPortListUpdate",
                                    "VxlanConfigReconcile" ] )

   sh.registerStage( "StrataL2", "StrataVxlanVirtualPortListReconcile", timeout=60 )

   sh.registerStageDependency( "L2MacTblShadowReconcile",
                               [ "ModInfoUpdate", "StrataLagStatusUpdate", 
                                 "LinkStatusUpdate", 
                                 "StrataVxlanVirtualPortListReconcile" ] )
   sh.registerStage( "StrataL2", "L2MacTblShadowReconcile", timeout=120 )

   # L2MacAddrSmUpdate uses the dot1x host table to reconcile hardware saved
   # configuredStaticMac entries to authenticatedMac entries, so requires
   # that the restoration of the dot1x host table is completed before running,
   # thus the dependency on Dot1xStatusReady
   sh.registerStageDependency( "L2MacAddrSmUpdate",
                               [ "EbraStatusUpdate", 
                                 "L2MacTblShadowReconcile",
                                 "BridgingTopoConfigUpdate",
                                 "Dot1xStatusReady" ] )
   sh.registerStage( "StrataL2", "L2MacAddrSmUpdate", timeout=120 )

   sh.registerStageDependency( "L2SubIntfReconcile", [ "L2MacAddrSmUpdate" ] )
   sh.registerStage( "StrataL2", "L2SubIntfReconcile", timeout=120 )

   sh.registerStageDependency( "EbraSubIntfUp", 
                               [ "EbraStatusUpdate", "L2SubIntfReconcile" ] )
   sh.registerStage( "Ebra", "EbraSubIntfUp", timeout=60 )

   sh.registerStageDependency( "VrfStatusUpdate",
                               [ "EbraStatusUpdate", "EbraSubIntfUp" ] )
   sh.registerStage( "Ira", "VrfStatusUpdate", timeout=60 )

   sh.registerStageDependency( "VrfRoutingInfoUpdate", [ "VrfStatusUpdate" ] )
   sh.registerStage( "IpRib", "VrfRoutingInfoUpdate", timeout=60 )

   sh.registerStageDependency( "IpIntfStatusUpdate", [ "VrfRoutingInfoUpdate" ] )
   sh.registerStage( "Ira", "IpIntfStatusUpdate", timeout=60 )
   sh.registerStage( "Bgp", "IpIntfStatusUpdate", timeout=60 )

   sh.registerStageDependency( "ArpStatusUpdate", [ "EbraStatusUpdate",
                                                       "IpIntfStatusUpdate" ] )

   sh.registerStage( "Arp", "ArpStatusUpdate", timeout=60 )

   sh.registerStageDependency( "FibRouteUpdate", [ "ArpStatusUpdate" ] )
   sh.registerStage( "Rib", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Rib-vrf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Bgp", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "ConnectedRoute", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "StaticRoute", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "RouteInput", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Isis", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Isis-vrf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf-vrf", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf3", "FibRouteUpdate", timeout=60 )
   sh.registerStage( "Ospf3-vrf", "FibRouteUpdate", timeout=60 )

   sh.registerStageDependency( "L3FibReady", [ "FibRouteUpdate" ] )
   sh.registerStage( "StrataL3", "L3FibReady", timeout=600 )

   sh.registerStageDependency( "L2RibUpdate", [ "L3FibReady",
                                                "Dot1xStatusReady",
                                                "L2MacAddrSmUpdate" ] )

   sh.registerStage( "Dot1x", "L2RibUpdate", enableAutoComplete=True,
                     autoCompleteTimeout=120 )
   sh.registerStage( "Bgp", "L2RibUpdate", enableAutoComplete=True,
                     autoCompleteTimeout=120 )
   sh.registerStage( "StrataL2", "L2RibUpdate", enableAutoComplete=True,
                     autoCompleteTimeout=120 )
  
   sh.registerStageDependency( "L2RibReconcile", [ "L2RibUpdate" ] )
   
   sh.registerStage( "L2Rib", "L2RibReconcile", enableAutoComplete=True,
                     autoCompleteTimeout=60 )

   sh.registerStageDependency( "L2RibReady", [ "L2RibReconcile" ] )
   
   sh.registerStage( "Bgp", "L2RibReady", enableAutoComplete=True,
                     autoCompleteTimeout=120 )
   sh.registerStage( "StrataL2", "L2RibReady", enableAutoComplete=True,
                     autoCompleteTimeout=120 )

   sh.registerStageDependency( "L2MacAddrSmReconcile", [ "L2RibReady" ] )
   sh.registerStage( "StrataL2", "L2MacAddrSmReconcile", timeout=120 )

   sh.registerStageDependency( "L2McastSmReconcile",
                               [ "EbraStatusUpdate", "ModInfoUpdate",
                                 "StrataLagStatusUpdate", "IpIntfStatusUpdate",
                                 "L2MacAddrSmReconcile" ] )
   sh.registerStage( "StrataL2", "L2McastSmReconcile", timeout=120 )

   sh.registerStageDependency( "L3UcastSmsReconcile",
                                  [ "ArpStatusUpdate", "L3FibReady",
                                    "L2MacAddrSmReconcile",
                                    "StrataLagStatusUpdate" ] )

   sh.registerStage( "StrataL3", "L3UcastSmsReconcile", timeout=120 )

 
   sh.registerStageDependency( "MrouteReconstructUpdate", [ "ModInfoUpdate" ] )

   sh.registerStage( "StrataL3", "MrouteReconstructUpdate", timeout=60 )

   # Pim is dependent on IP interfaces being published.
   sh.registerStageDependency( "PimIntfUpdate", [ "IpIntfStatusUpdate" ] )
   sh.registerStage( "Pim", "PimIntfUpdate", timeout=600 )

   # Pimsm is dependent on Pim interfaces being published.
   sh.registerStageDependency( "MfibRouteUpdate",
                               [ "PimIntfUpdate", "MrouteReconstructUpdate" ] )
   sh.registerStage( "Pimsm", "MfibRouteUpdate", timeout=600 )

   # PimBidir is dependent on Pim interfaces being published.
   sh.registerStageDependency( "MfibBidirRouteUpdate", [ "PimIntfUpdate" ] )
   sh.registerStage( "PimBidir", "MfibBidirRouteUpdate", timeout=600 )

   sh.registerStageDependency( "L3MfibReady", [ "MfibRouteUpdate", "L3FibReady" ] )
   sh.registerStage( "StrataL3", "L3MfibReady", timeout=600 )

   sh.registerStageDependency( "L3McastSmsReconcile",
                               [ "MrouteReconstructUpdate", "L3UcastSmsReconcile",
                                 "L3MfibReady" ] )
   sh.registerStage( "StrataL3", "L3McastSmsReconcile", timeout=30 )

   sh.registerStageDependency( "VlanReconcile",
                               [ "BridgingTopoConfigUpdate", "LinkStatusUpdate",
                                 "L3UcastSmsReconcile", "L3McastSmsReconcile" ] )
   sh.registerStage( "StrataVlanTopo", "VlanReconcile", timeout=120 )

   sh.registerStageDependency( "StrataSliceL2AgentReconcile",
                               [ "StrataMmuReconcile", "StrataLagStatusUpdate",
                                 "L2MacAddrSmReconcile", "L2McastSmReconcile" ] )
   sh.registerStage( "Strata", "StrataSliceL2AgentReconcile", complete=True,
                     timeout=120 )
   registerLinecardSliceStage( sh, "StrataSliceL2AgentReconcile" )

   sh.registerStageDependency( "StrataL2QosStatusReconcile",
                               [ "StrataSliceL2AgentReconcile" ] )
   sh.registerStage( "StrataL2", "StrataL2QosStatusReconcile", timeout=60 )

   # Stage to notify that Vxlan Unicast Tunnel configs are ready
   sh.registerStageDependency( "VxlanUCTunnelsUpdate", 
                               [ "VxlanConfigReconcile",
                                 "L3UcastSmsReconcile",
                                 "StrataL2QosStatusReconcile" ] )
   sh.registerStage( "StrataL2", "VxlanUCTunnelsUpdate", timeout=120 ) 

   sh.registerStageDependency( "VxlanUCTunnelsReconcile",
                                  [ "ModInfoUpdate",
                                    "VxlanConfigUpdate",
                                    "VxlanUCTunnelsUpdate" ] )

   # Stage to notify that vxlan is ready on l3 agent
   sh.registerStageDependency( "L3VxlanReadyUpdate",
                               [ "L3McastSmsReconcile",
                                 "VxlanUCTunnelsReconcile" ] )
   sh.registerStage( "StrataL3", "L3VxlanReadyUpdate", timeout=120 )
   
   sh.registerStageDependency( "PrepareL3TableFastWrites",
                               [ "L3VxlanReadyUpdate" ] )
   sh.registerStage( "StrataL3", "PrepareL3TableFastWrites", timeout=60 )

   # Stage to notify that vxlan is ready on l2 agent
   sh.registerStageDependency( "L2VxlanReadyUpdate",
                               [ "L3VxlanReadyUpdate" ] )
   sh.registerStage( "StrataL2", "L2VxlanReadyUpdate", timeout=120 )


   sh.registerStage( "StrataL3", "VxlanUCTunnelsReconcile", timeout=120 )

   sh.registerStageDependency( "StrataLagSvpReconcile",
                               [ 'HwLagStatusReconcile',
                                 'VxlanUCTunnelsUpdate' ] )
   sh.registerStage( "StrataLag", "StrataLagSvpReconcile", timeout=60 )

   # StrataMirroring state machines in turn depend on PI stage being published
   # as well as LagStatusUpdate
   sh.registerStageDependency( "StrataMirroringReconcile",
                               [ "MirroringHwConfigUpdate",
                                 "StrataLagStatusUpdate",
                                 "L3UcastSmsReconcile" ] )
   sh.registerStage( "StrataMirror", "StrataMirroringReconcile", timeout=60 )
   # Once StrataMirroring has reconciled, Strata needs to reconcile Mirror bits
   # in port table entry
   sh.registerStageDependency( "StrataMirroringPortEntryReconcile",
                               [ "StrataMirroringReconcile" ] )
   sh.registerStage( "Strata", "StrataMirroringPortEntryReconcile", complete=True,
                     timeout=60 )
   registerLinecardSliceStage( sh, "StrataMirroringPortEntryReconcile" )

   sh.registerStageDependency( "StrataSliceL3AgentReconcile",
                               [ "L3UcastSmsReconcile",
                                 "L3McastSmsReconcile",
                                 "StrataSliceL2AgentReconcile" ] )
   sh.registerStage( "Strata", "StrataSliceL3AgentReconcile", complete=True,
                     timeout=120 )
   registerLinecardSliceStage( sh, "StrataSliceL3AgentReconcile" )

   sh.registerStageDependency( "DownLinksUpdate",
                               [ "VlanReconcile", ] )
   sh.registerStage( "Ebra", "DownLinksUpdate", timeout=30 )

   sh.registerStageDependency( "StrataLagSvpReconcile",
                               [ 'HwLagStatusReconcile',
                                 'VxlanUCTunnelsUpdate' ] )
   sh.registerStage( "StrataLag", "StrataLagSvpReconcile", timeout=60 )

   sh.registerStageDependency( "BootSanityCheck",
                               [ "DownLinksUpdate",
                                 "StrataMirroringPortEntryReconcile",
                                 "VxlanUCTunnelsReconcile",
                                 "StrataLagSvpReconcile",
                                 "L2RibReady" ] )
   sh.registerStage( "Launcher", "BootSanityCheck", timeout=120 )

   sh.registerStageDependency( "QuiesceTraffic",
                               [ "L2VxlanReadyUpdate",
                                 "L3McastSmsReconcile",
                                 "PrepareL3TableFastWrites",
                                 "StrataMirroringReconcile",
                                 "VlanReconcile",
                                 "StrataSliceL2AgentReconcile",
                                 "StrataSliceL3AgentReconcile" ] )
   sh.registerStage( "Strata", "QuiesceTraffic", complete=True, timeout=60 )
   registerAllSliceStage( sh, "QuiesceTraffic" )

   sh.registerStageDependency( "BulkDownloadStart",
                               [ "QuiesceTraffic", ] )
   sh.registerStage( "StrataL3", "BulkDownloadStart", timeout=60 )
   sh.registerStage( "StrataL2", "BulkDownloadStart", timeout=60 )
   sh.registerStage( "StrataMirror", "BulkDownloadStart", timeout=60 )
   sh.registerStage( "StrataVlanTopo", "BulkDownloadStart", timeout=60 )
   sh.registerStage( "Strata", "BulkDownloadStart", complete=True, timeout=60 )
   registerAllSliceStage( sh, "BulkDownloadStart" )


   sh.registerStageDependency( "BulkDownloadComplete",
                               [ "BulkDownloadStart", ] )
   sh.registerStage( "Strata", "BulkDownloadComplete", complete=True,
                     timeout=60 )
   registerAllSliceStage( sh, "BulkDownloadComplete" )
   sh.registerStageDependency( "DownLinksUpdate",
                               [ "BulkDownloadComplete" ] )
