# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import StageSysdbHelper

def registerAsuFastBootStrata( entityManager ):
   sh = StageSysdbHelper.StageHelper( entityManager, 'boot' )
   sh.applicationIs( "Asu Fastboot boot" )

   sh.registerStageDependency( "Fru-Plugins", [] )
   sh.registerStage( "Fru", "Fru-Plugins", timeout=60 )

   sh.registerStageDependency( "PrimaryAgent", [ "Fru-Plugins" ] )

   # First arg is supposed to be agent name and not agent launch name.
   # Make sure it's the same as 'name' entry in launcher's agent config,
   # which is 'Scd' in this case.
   sh.registerStage( "Scd", "PrimaryAgent" )
   sh.registerStage( "ReloadCauseAgent", "PrimaryAgent", complete=True )

   sh.registerStage( "PlutoSmbus", "PrimaryAgent", complete=True )
   sh.registerStage( "PLSmbusMediator", "PrimaryAgent", complete=True )

   # First arg is supposed to be agent name and not agent launch name.
   # Make sure it's the same as 'name' entry in launcher's agent config,
   # which is 'Smbus' in this case.
   sh.registerStage( "Smbus", "PrimaryAgent" )
   sh.registerStage( "PciBus", "PrimaryAgent", timeout=60 )
   sh.registerStage( "PLSystem", "PrimaryAgent" )
   # MaintenanceMode is started to set qualPath for Rib/ArBgp
   sh.registerStage( "MaintenanceMode", "PrimaryAgent", complete=True )

   sh.registerStageDependency( "HardwareAgent", [] )
   sh.registerStage( "StrataCentral", "HardwareAgent", timeout=60 )
   sh.registerStage( "StrataLag", "HardwareAgent", complete=True )

   sh.registerStageDependency( "SecondaryHardwareAgent", [ "HardwareAgent",
                                                           "PrimaryAgent" ] )
   sh.registerStage( "Strata", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "Strata-FixedSystem", "SecondaryHardwareAgent",
                     complete=True )

   # First arg is supposed to be agent name and not agent launch name.
   # Make sure it's the same as 'name' entry in launcher's agent config,
   # which is 'Xcvr' in this case.
   sh.registerStage( "Xcvr", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "StrataL2", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "StrataL3", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "StrataLag", "SecondaryHardwareAgent", complete=True )
   sh.registerStage( "StrataVlanTopo", "SecondaryHardwareAgent", complete=True )

   sh.registerStageDependency( "SliceAgentChipReset", [ "SecondaryHardwareAgent" ] )
   sh.registerStage( "Strata", "SliceAgentChipReset", complete=True )
   sh.registerStage( "Strata-FixedSystem", "SliceAgentChipReset", timeout=60 )

   sh.registerStageDependency( "XcvrWarm", [ "SliceAgentChipReset" ] )
   sh.registerStage( "Xcvr", "XcvrWarm", timeout=60 )

   sh.registerStageDependency( "HardwareAgentChipReset", [ "SliceAgentChipReset" ] )
   sh.registerStage( "EpilAgent", "HardwareAgentChipReset", complete=True )

   sh.registerStageDependency( "PhyInitAllowed", [ "XcvrWarm" ] )
   sh.registerStage( "Strata", "PhyInitAllowed", complete=True )
   sh.registerStage( "Strata-FixedSystem", "PhyInitAllowed", timeout=60 )

   sh.registerStageDependency( "BfdStatusUpdate", [] )
   sh.registerStage( "Bfd", "BfdStatusUpdate", timeout=60 )

   # Adding 'InfrastructureAgent' stage before NetworkAgent stage. As of now
   # Ira is the only participating agent. This is required as Ira agent needs to
   # set the qualpath as to whether which routing agents are to run
   sh.registerStageDependency( "InfrastructureAgent", [] )
   sh.registerStage( "Ira", "InfrastructureAgent", timeout=60 )

   sh.registerStageDependency( "NetworkAgent",
                               [ "HardwareAgent", "BfdStatusUpdate",
                                 "InfrastructureAgent" ] )
   sh.registerStage( "Stp", "NetworkAgent", complete=True )
   sh.registerStage( "StpTopology", "NetworkAgent", complete=True )
   sh.registerStage( "TopoAgent", "NetworkAgent", complete=True )
   sh.registerStage( "Aaa", "NetworkAgent", complete=True )
   sh.registerStage( "SuperServer", "NetworkAgent", complete=True )
   sh.registerStage( "PhyEthtool", "NetworkAgent", complete=True )
   sh.registerStage( "Arp", "NetworkAgent", complete=True )
   sh.registerStage( "Acl", "NetworkAgent", complete=True )
   sh.registerStage( "PortSec", "NetworkAgent", complete=True )
   sh.registerStage( "Qos", "NetworkAgent", complete=True )

   sh.registerStage( "Ebra", "NetworkAgent" )
   sh.registerStage( "Lag", "NetworkAgent" )
   sh.registerStage( "LacpTxAgent", "NetworkAgent" )
   sh.registerStage( "Rib", "NetworkAgent", timeout=120 )
   sh.registerStage( "Rib-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf3", "NetworkAgent", timeout=120 )
   sh.registerStage( "Ospf3-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "Isis", "NetworkAgent", timeout=120 )
   sh.registerStage( "Isis-vrf", "NetworkAgent", timeout=120 )
   sh.registerStage( "KernelFib", "NetworkAgent", complete=True )
   sh.registerStage( "KernelNetworkInfo", "NetworkAgent", complete=True )

   sh.registerStageDependency( "HardwareAgentComplete",
            [ "HardwareAgent", "XcvrWarm"  ] )
   # Strata already defers update by 60 seconds, hence more
   sh.registerStage( "Strata", "HardwareAgentComplete", complete=True )
   sh.registerStage( "Strata-FixedSystem", "HardwareAgentComplete", timeout=180 )

