# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Arnet

def EndPoint( ipString ):
   address = Arnet.IpGenAddr( str( ipString ) )
   return tacEndPoint( address )

def Color( value ):
   return tacColor( value )

def PolicyKey( ep, c ):
   endPoint = EndPoint( ep )
   color = Color( c )
   return Tac.const( tacPolicyKey( endPoint, color ) )

def cbfFecOverrideMapPath():
   return 'te/segmentrouting/cbfFecOverrideMap'

def srTePolicyStatusPath():
   return 'srTePolicy/PolicyStatus'

tacEndPoint = Tac.Type( 'SrTePolicy::EndPoint' )
tacColor = Tac.Type( 'SrTePolicy::Color' )
tacPolicyKey = Tac.Type( 'SrTePolicy::PolicyKey' )
tacEnlp = Tac.Type( 'SrTePolicy::Enlp' )
tacEnlpEnum = Tac.Type( 'SrTePolicy::Enlp::Enum' )
