# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Plugins
import Tracing
import Toggles.VxlanSnmpToggleLib

handle = Tracing.Handle( 'VxlanSnmp' )
t0 = handle.trace0

class VxlanSnmpPlugin( object ):
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      vxlanRoot = snmpRoot.mkdir( 'vxlan' )
      vxlanRoot.newEntity( 'VxlanSnmp::VxlanMib', 'vxlanmib' )

@Plugins.plugin( provides=( 'snmp/vxlan', ) )
def Plugin( ctx ):
   if Toggles.VxlanSnmpToggleLib.toggleVxlanSnmpEnabled():
      t0( 'Loading VxlanSnmp plugin' )
      VxlanSnmpPlugin( ctx )
   else:
      t0( 'Skipping VxlanSnmp plugin (toggled off)' )
