# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing, Cell

t0 = Tracing.trace0

RedundancyMode = Tac.Type( "Election::RedundancyMode" )

class RedSupSnmpPlugin( object ):
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      redSupSnmpRoot = snmpRoot.mkdir( 'redsup' )
      self.root = redSupSnmpRoot.newEntity( 'RedSupSnmp::Root', 'root' )

      self.electionStatus = None
      mg = entityManager.mountGroup()
      self.redundancyMib = mg.mount( 'redundancy/snmp/status',
                                     'RedSupSnmp::RedundancyMib', 'w' )
      self.redundancyConfig = mg.mount( 'redundancy/config', 
                                        'Redundancy::RedundancyConfig', 'r' )
      # redundancy/status is already mounted through CAgent layer
      self.redundancyStatus = \
         entityManager.lookup( Cell.path( 'redundancy/status' ) ) 

      if Cell.cellType() == 'supervisor':
         # Election::Status should exist for modular systems
         self.electionStatus = mg.mount(
               Cell.path( 'redundancy/election/status' ),
               'Election::Status', 'r' )
      elif Cell.cellType() == 'fixed':
         self.electionStatus = self.fixedSystemStatus()

      def _finishMounts():
         self.root.electionStatus = self.electionStatus
         self.root.redundancyConfig = self.redundancyConfig
         self.root.redundancyStatus = self.redundancyStatus
         self.unitStateSm = Tac.newInstance( "RedSupSnmp::UnitStateSm",
               self.electionStatus, self.redundancyMib, self.root )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )
   
   def fixedSystemStatus( self ):
      # Create a dummy Election::Status for fixed systems, and set attributes
      # so that Snmp can return sane values
      electionStatus = Tac.newInstance( "Election::Status", "status" )
      electionStatus.redundancyMode = RedundancyMode.active
      electionStatus.lastRedundancyModeChangeReason = "None"
      return electionStatus


redSupSnmpPlugin = None

def Plugin( ctx ):
   t0( 'Loading RedSup SnmpPlugin' )
   global redSupSnmpPlugin
   redSupSnmpPlugin = RedSupSnmpPlugin( ctx )
   Tac.dlopen( 'libRedSupSnmpSysdb.so' )
   Tac.dlopen( 'libRedSupSnmpSm.so' )
