# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

class PimSnmpPlugin( object ):
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      AddressFamily = Tac.Type( 'Arnet::AddressFamily' )
      mg = entityManager.mountGroup()

      mg.mount( 'routing/multicast/vrf/config',
            'Routing::Multicast::Fib::VrfConfig', 'r' )

      pimConfigColl = mg.mount( 'routing/pim/config',
                                'Routing::Pim::ConfigColl', 'r' )

      pimGlobalStatusColl = {}
      for af in [ AddressFamily.ipv4, ]:
         pimGlobalStatusColl[ af ] = mg.mount(
               Tac.Type( 'Routing::Pim::GlobalStatus' ).mountPath( af ),
               'Routing::Pim::GlobalStatus', 'r' )

      allIntfStatusDir = mg.mount( 'interface/status/all',
                                   'Interface::AllIntfStatusDir', 'r' )

      bsrStatusColl = mg.mount( 'routing/pim/bsr/statuscoll',
                            'Routing::Pim::Bsr::StatusColl', 'r' )

      bsrConfigColl = mg.mount( 'routing/pim/bsr/configcoll',
                            'Routing::Pim::Bsr::ConfigColl', 'r' )

      crpStatusColl = mg.mount( 'routing/pim/bsr/rpcandidate',
                            'Routing::Pim::RpCandidateStatusColl', 'r' )

      staticRpStatusColl = mg.mount( 'routing/pim/staticRpStatus/sparsemode',
                                 'Routing::Pim::RpCandidateStatusColl', 'r' )

      snmpAgentStatus = mg.mount( 'snmp/status', 'Snmp::Status', 'r' )

      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      pimRoot = snmpRoot.mkdir( 'pim' )
      pimMibRoot = pimRoot.mkdir( 'snmpPimMIB' )

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None
      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( "Routing::Pim::SnmpAgent::Root",
                      "pimSnmpAgentRoot" )

         self.root_.pimAllStatusColl = ()
         self.root_.pimStatusColl = ()

         self.root_.pimMibRoot = pimMibRoot
         self.root_.pimConfigColl = pimConfigColl
         self.root_.allIntfStatusDir = allIntfStatusDir
         self.root_.bsrStatusColl = bsrStatusColl
         self.root_.crpStatusColl = crpStatusColl
         self.root_.staticRpStatusColl = staticRpStatusColl
         self.root_.bsrConfigColl = bsrConfigColl
         self.root_.snmpAgentStatus = snmpAgentStatus
         self.root_.em = entityManager.cEntityManager()

         for af in [ AddressFamily.ipv4, ]:
            self.root_.pimGlobalStatusColl[ af ] = pimGlobalStatusColl[ af ]
            # TODO - We should convert PimGlobalStatusReaderSm to store a
            # TacSharedMem::EntityManager::Ptr instead of the deprecated
            # TacSmash::Mount
            smashMount = Tac.newInstance( 'TacSmash::Mount',
                                          entityManager.cEntityManager() )
            self.root_.pimGlobalStatusReaderSm.newMember(
                               af,
                               self.root_.pimGlobalStatusColl[ af ],
                               self.root_.pimAllStatusColl,
                               False,
                               Tac.activityManager.clock,
                               smashMount )

            self.root_.pimGlobalStatusModeFilterSm = (
                               self.root_.pimAllStatusColl,
                               self.root_.pimStatusColl,
                               "modePimSmAndBidir" )

            self.root_.rootSm.newMember(
                                  af,
                                  self.root_.allIntfStatusDir,
                                  self.root_.pimMibRoot, 
                                  self.root_.bsrStatusColl,
                                  self.root_.crpStatusColl,
                                  self.root_.staticRpStatusColl,
                                  self.root_.bsrConfigColl,
                                  self.root_.pimStatusColl,
                                  self.root_.pimConfigColl,
                                  self.root_.snmpAgentStatus,
                                  self.root_.em )
      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   PimSnmpPlugin( ctx )
   Tac.dlopen( "libPimSnmp.so" )
