# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac

class MsdpSnmpPlugin( object ):
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()

      mg = entityManager.mountGroup()
      msdpConfigColl = mg.mount( 'routing/msdp/config',
                             'Routing::Msdp::ConfigColl',
                             'r' )
      msdpStatusColl = mg.mount( 'routing/msdp/status',
                                 'Routing::Msdp::StatusColl',
                                 'rO' )
      msdpPimStatusColl = mg.mount( 'routing/msdp/pimstatus',
                                    'Routing::Msdp::PimStatusColl', 'rO' )
      rpfMapStatusDir = mg.mount( 'routing/msdp/rpfMapStatus', 
            'Tac::Dir', 'ri' )
      snmpAgentStatus = mg.mount( 'snmp/status', 'Snmp::Status', 'r' )

      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      msdpRoot = snmpRoot.mkdir( 'msdp' )
      msdpMibRoot = msdpRoot.mkdir( 'snmpMsdpMIB' )
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None
      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( "MsdpSnmpAgent::Root", 
               "MsdpSnmpAgentRoot" )
         self.root_.configColl = msdpConfigColl
         self.root_.statusColl = msdpStatusColl
         self.root_.pimStatusColl = msdpPimStatusColl
         self.root_.rpfMapStatusDir = rpfMapStatusDir
         self.root_.snmpAgentStatus = snmpAgentStatus
         self.root_.msdpMibRoot = msdpMibRoot
         self.root_.rootSm =  ( self.root_.configColl,
                                  self.root_.statusColl,
                                  self.root_.pimStatusColl,
                                  self.root_.rpfMapStatusDir,
                                  self.root_.snmpAgentStatus,
                                  self.root_.msdpMibRoot)
      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   MsdpSnmpPlugin( ctx )
   Tac.dlopen( "libMsdpSnmp.so" )
