# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tracing
import Tac
import SharedMem
import Toggles.MacsecSnmpToggleLib

handle = Tracing.Handle( 'MacsecSnmp' )
t0 = handle.trace0

class MacsecSnmpPlugin( object ):
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      macsecRoot = snmpRoot.mkdir( 'macsec' )
      macsecMib = macsecRoot.newEntity( 'MacsecSnmp::MacsecMib', 'macsecmib' )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      mg = entityManager.mountGroup()
      macsecStatus = mg.mount( 'macsec/status', 'Macsec::Status', 'r' )
      phyStatusDir = mg.mount( 'hardware/phy/status/macsec/slice',
                               'Tac::Dir', 'ri' )

      shMemEm = SharedMem.entityManager( sysdbEm=entityManager )

      macsecAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      def _finishMounts():
         self.root_ = macsecAgentRoot.newEntity( 'MacsecSnmp::Agent::Root',
               'MacsecSnmp' )
         # MacsecSnmp agent constructor;
         self.root_.agent = ( macsecStatus, macsecMib, ifMib, shMemEm,
                              phyStatusDir )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   if Toggles.MacsecSnmpToggleLib.toggleMacsecSnmpEnabled():
      t0( 'Loading MacsecSnmp plugin' )
      MacsecSnmpPlugin( ctx )
   else:
      t0( 'Skipping MacsecSnmp plugin (toggled off)' )
