# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tracing

traceHandle = Tracing.Handle( 'LdpStdSnmp' )
t0 = traceHandle.trace0

class LdpStdSnmpPlugin( object ):
   def __init__( self, ctx ):
      self.root_ = None
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      ldpDir = snmpRoot.mkdir( 'ldp' )
      mib = ldpDir.newEntity( 'LdpSnmp::LdpSnmpMib', 'ldpMib' )
      mib.stdMib = ( 'ldpStdMib', )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      mg = entityManager.mountGroup()
      protoConfigColl = mg.mount( 'mpls/ldp/ldpProtoConfigColl',
                                  'Ldp::LdpProtoConfigColl', 'r' )
      configColl = mg.mount( 'mpls/ldp/ldpConfigColl', 'Ldp::LdpConfigColl' )
      statusColl = mg.mount( 'mpls/ldp/ldpStatusColl', 'Ldp::LdpStatusColl' )

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'LdpSnmp::AgentRoot',
                                               'LdpSnmp' )
         self.root_.protoConfigColl = protoConfigColl
         self.root_.configColl = configColl
         self.root_.statusColl = statusColl
         self.root_.mib = mib
         self.root_.rootSm = ( protoConfigColl, configColl, statusColl, ifMib, mib )

      t0('LdpStdSnmp mouting finished!')
      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   t0( 'LdpStdSnmp plugin loading... ' )
   LdpStdSnmpPlugin( ctx )
