# Copyright (c) 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Note: the dependency on IpLib due to the Ira::IraIpStatusMounter reference
# is forced by the import of IpLibConsts, which is also needed to import the
# DEFAULT_VRF definition.
import SharedMem, Smash, IpLibConsts, FibUtils, Cell, Tac, Plugins
import Toggles.NexthopGroupToggleLib as NhgToggle

# pkgdeps: import Toggles.IraSnmpToggleLib

FeatureId = Tac.Type( 'FlexCounters::FeatureId' )
FeatureIdEnumVal = Tac.Type( 'FlexCounters::FeatureIdEnumVal' )
FapId = Tac.Type( 'FlexCounters::FapId' )

# pylint: disable-msg=W0201
class IraSnmpPlugin( object ):
   def __init__( self, ctx ):
      self.entityManager_ = ctx.entityManager()
      self.ctx_ = ctx
      self.routeTablesEnabled_ = not self.ctx_.objectsDisabled( 'route-tables' )
      sysdb = self.entityManager_.root()
      snmpAgentRoot = sysdb.parent[ 'Snmp' ][ 'root' ]
      scheduler = snmpAgentRoot.scheduler
      snmpRoot = sysdb.parent[ 'snmp' ]
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]
      ipRoot = snmpRoot.mkdir( 'ip' )
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]
      ipMib = ipRoot.newEntity( 'IpSnmp::IpMib', 'ipmib' )
      ipForwardMib = ipRoot.newEntity( 'IpSnmp::IpForwardMib', 'ipforwardmib' )
      fibStatsMib = ipRoot.newEntity( 'FibStatsSnmp::FibStatsMib', 'fibstatsmib' )
      ipVrfMib = ipRoot.newEntity( 'IpSnmp::IpVrfMib', 'ipvrfmib' )
      nexthopRoot = snmpRoot.mkdir( 'nexthopgroup' )
      nexthopGroupMib = nexthopRoot.newEntity( 'NexthopGroupSnmp::NexthopGroupMib',
                                               'nexthopgroupmib' )
      self.vrfMibsDir_ = ipRoot.newEntity( 'IpSnmp::VrfMibsDir', 'vrf' )
      mg = self.entityManager_.mountGroup()
      self.l3Config_ = mg.mount( "l3/config", "L3::Config", "r" ) 
      if self.routeTablesEnabled_:
         self.routingConfig_ = mg.mount( 'routing/routelistconfig',
               'Routing::RouteListConfig', 'r' )
         self.routing6Config_ = mg.mount( 'routing6/routelistconfig',
               'Routing6::RouteListConfig',
                                          'r' )
      else:
         self.routingConfig_ = None
         self.routing6Config_ = None
      self.ipConfig_ = mg.mount( 'ip/config', 'Ip::Config', 'r' )
      Tac.Type( "Ira::IraIpStatusMounter" ).doMountEntities( mg.cMg_, True, True )
      self.ipStatus_ = mg.mount( 'ip/status', 'Ip::Status', 'r' )
      self.ip6Config_ = mg.mount( 'ip6/config', 'Ip6::Config', 'r' )
      self.ip6Status_ = mg.mount( 'ip6/status', 'Ip6::Status', 'r' )
      # Mount l3/intf/config for ip/config, ip6/config l3Config Ptr.
      mg.mount( "l3/intf/config", "L3::Intf::ConfigDir", "r" )
      self.intfStatus_ = mg.mount( 'interface/status/all',
                                   'Interface::AllIntfStatusDir', 'r' )
      nexthopGroupCliConfig = mg.mount( 'routing/nexthopgroup/input/cli',
                                        'Routing::NexthopGroup::ConfigInput', 'r' )
      nexthopGroupConfigInput = mg.mount( 'routing/nexthopgroup/input/config',
                                          'Tac::Dir', 'ri' )
      self.routingVrfInfoDir_ = mg.mount( 'routing/vrf/routingInfo/status',
                                          'Tac::Dir', 'ri' )
      self.routing6VrfInfoDir_ = mg.mount( 'routing6/vrf/routingInfo/status',
                                          'Tac::Dir', 'ri' )
      self.allVrfStatusLocal_ = mg.mount( Cell.path( 'ip/vrf/status/local' ),
                                          'Ip::AllVrfStatusLocal', 'r' )
      self.allVrfStatusGlobal_ = mg.mount( 'ip/vrf/status/global',
                                           'Ip::AllVrfStatusGlobal', 'r' )
      self.allVrfConfig_ = mg.mount( 'ip/vrf/config', 'Ip::AllVrfConfig', 'r' )
      self.vrfNameStatus_ = mg.mount( Cell.path( 'vrf/vrfNameStatus' ),
                                      "Vrf::VrfIdMap::NameToIdMapWrapper", "r" )
      self.snmpStatus_ = mg.mount( 'snmp/status', 'Snmp::Status', 'r' )
      self.routingVrfConfigDir_ = \
         mg.mount( 'routing/vrf/config', 'Routing::VrfConfigDir', 'r' )
      self.routing6VrfConfigDir_ = \
         mg.mount( 'routing6/vrf/config', 'Routing6::VrfConfigDir', 'r' )
      self.flexFeatureStatusDir_ = \
         mg.mount( 'flexCounter/featureStatusDir', 'Tac::Dir', 'ri' )
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]

      # mount routing/status from Smash
      shmemEm = SharedMem.entityManager( sysdbEm=self.entityManager_ )
      routeInfo = FibUtils.routeStatusInfo( 'shadow' )
      if self.routeTablesEnabled_:
         self.routeStatus_ = shmemEm.doMount( 'routing/status',
                                              'Smash::Fib::RouteStatus', routeInfo )
         self.route6Status_ = shmemEm.doMount( 'routing6/status',
                                               'Smash::Fib6::RouteStatus',
                                               routeInfo )
      else:
         self.routeStatus_ = None
         self.route6Status_ = None
      self.arpSmash_ = shmemEm.doMount( 'arp/status', 'Arp::Table::Status',
                                        Smash.mountInfo( 'shadow' ) )
      self.vrfIdStatus_ = shmemEm.doMount( 'vrf/vrfIdMapStatus',
                                           'Vrf::VrfIdMap::Status',
                                           Smash.mountInfo( 'shadow' ) )

      # Mounting counterTable to fetch current counters for nexthop groups
      mountPath = 'flexCounter/counterTable/%u/%u' % (
                  FeatureIdEnumVal.enumVal( FeatureId.Nexthop ), FapId.allFapsId )
      tunnelCounterInfo = Smash.mountInfo( 'reader' )
      self.tunnelCounterStatus_ = shmemEm.doMount( mountPath,
                                                   'FlexCounters::CounterTable',
                                                   tunnelCounterInfo )

      # Mounting snapshotTable to fetch snapshot counters for nexthop groups
      mountPath = 'flexCounter/snapshotCounterTable/%u/%u' % (
                  FeatureIdEnumVal.enumVal( FeatureId.Nexthop ), FapId.allFapsId )
      tunnelCounterInfo = Smash.mountInfo( 'reader' )
      self.snapShotCounterStatus_ = shmemEm.doMount( mountPath,
                                                     'FlexCounters::CounterTable',
                                                     tunnelCounterInfo )

      # Mounting counterTable to fetch current ipv4/v6 counters for ARISTA-IP-MIB
      smashInfo = Smash.mountInfo( 'reader' )
      mountPath = 'flexCounters/counterTable/Ipv4v6Ingress/%u' % FapId.allFapsId
      self.ingressIpCounterTable = shmemEm.doMount( mountPath,
                                                    'FlexCounters::CounterTable',
                                                    smashInfo )
      mountPath = 'flexCounters/counterTable/Ipv4v6Egress/%u' % FapId.allFapsId
      self.egressIpCounterTable = shmemEm.doMount( mountPath,
                                                   'FlexCounters::CounterTable',
                                                   smashInfo )

      # Mouting nexthopgroupentry status for nexthopgroup mib
      nexthopEntryTableInfo = Tac.Value( 'NexthopGroup::TableInfo' )
      nexthopEntryStatusMountInfo = nexthopEntryTableInfo.entryStatus( 'shadow' )
      self.smashNhgStatus_ = shmemEm.doMount( "routing/nexthopgroup/entrystatus",
                                              "NexthopGroup::EntryStatus",
                                              nexthopEntryStatusMountInfo )

      # Mouting NexthopGroupCounterKeyInfo
      nexthopGroupCounterKeyInfo = Smash.mountInfo( 'shadow' )
      self.nexthopGroupCounterKeyStatus = shmemEm.doMount(
         "tunnel/nexthop/counterkeyinfo",
         "Routing::NexthopGroup::NexthopGroupEntryToCounterKeyTable",
         nexthopGroupCounterKeyInfo )

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'IpSnmp::Root', 'IpSnmp' )

         # Initialize FecModeSm to set the correct FecModeStatus
         fecModeStatus = Tac.newInstance( 'Smash::Fib::FecModeStatus', 'fms' )
         self.root_.fecModeSm = ( self.l3Config_, fecModeStatus )
         self.root_.fecModeRestartSm = ( fecModeStatus, )
         self.fecMode_ = fecModeStatus.fecMode

         # Mount the correct FEC table based on FecModeStatus
         shmemEm = SharedMem.entityManager( sysdbEm=self.entityManager_ )
         fwdInfo = FibUtils.forwardingStatusInfo( 'keyshadow' )
         if self.routeTablesEnabled_:
            if self.fecMode_ == 'fecModeUnified':
               self.forwardingStatus_ = shmemEm.doMount(
                  'forwarding/unifiedStatus', 'Smash::Fib::ForwardingStatus',
                  fwdInfo )
               self.forwarding6Status_ = shmemEm.doMount(
                  'forwarding6/unifiedStatus', 'Smash::Fib6::ForwardingStatus',
                  fwdInfo )
            else:
               self.forwardingStatus_ = shmemEm.doMount(
                  'forwarding/status', 'Smash::Fib::ForwardingStatus', fwdInfo )
               self.forwarding6Status_ = shmemEm.doMount(
                  'forwarding6/status', 'Smash::Fib6::ForwardingStatus', fwdInfo )
         else:
            self.forwardingStatus_ = None

         self.root_.ipConfig = self.ipConfig_
         self.root_.ipStatus = self.ipStatus_
         self.root_.ip6Config = self.ip6Config_
         self.root_.ip6Status = self.ip6Status_
         self.root_.intfStatusDir = self.intfStatus_
         self.root_.ipMib = ipMib
         self.root_.ipAddressTableSm = ( self.intfStatus_, ipMib,
                                         self.ipConfig_, self.ipStatus_,
                                         self.ip6Config_, self.ip6Status_ )
         self.root_.arpTableSm = (
            self.intfStatus_, ipMib, self.arpSmash_,
            Tac.newInstance( 'Vrf::VrfIdMap::VrfId' ).defaultVrf )
         self.root_.ipIfStatsTableSm = ( ifMib, self.flexFeatureStatusDir_,
            self.entityManager_.cEntityManager(), self.ingressIpCounterTable,
            self.egressIpCounterTable, ipMib )

         ipMib.newIpSwFwdStats( 'ipVersion4', IpLibConsts.DEFAULT_VRF )
         ipMib.newIpSwFwdStats( 'ipVersion6', IpLibConsts.DEFAULT_VRF )
         self.root_.ipForwardMib = ipForwardMib
         if self.routeTablesEnabled_:
            if self.fecMode_ != 'fecModeUnified':
               self.root_.ipRouteTableSm = ( scheduler,
                                             IpLibConsts.DEFAULT_VRF,
                                             ipForwardMib,
                                             self.routeStatus_,
                                             self.route6Status_,
                                             self.forwardingStatus_,
                                             self.forwarding6Status_,
                                             None,
                                             None,
                                             None,
                                             ifMib )
               self.root_.perVrfFecSm = ( self.root_.ipRouteTableSm,
                                          self.routeStatus_,
                                          self.forwardingStatus_ )
            else:
               self.root_.ipRouteTableSm = ( scheduler,
                                             IpLibConsts.DEFAULT_VRF,
                                             ipForwardMib,
                                             self.routeStatus_,
                                             self.route6Status_,
                                             self.forwardingStatus_,
                                             self.forwarding6Status_,
                                             self.forwardingStatus_,
                                             self.forwarding6Status_,
                                             None,
                                             ifMib )

            self.root_.fibStatsMib = fibStatsMib
            self.root_.fibStatsSm = (
                  self.routeStatus_, self.arpSmash_,
                  self.root_.arpTableSm.arpSmashVrfId, self.routingConfig_,
                  fibStatsMib )
            self.root_.fib6StatsSm = (
                  self.route6Status_, self.arpSmash_,
                  self.root_.arpTableSm.arpSmashVrfId, self.routing6Config_,
                  fibStatsMib )

         self.root_.vrfRootDir = ( 'vrfRootDir', )
         if self.routeTablesEnabled_:
            localForwardingFecs = self.root_.ipRouteTableSm.localForwardingFecs
         else:
            localForwardingFecs = None
         self.root_.vrfRootSm = ( self.fecMode_,
                                  scheduler, self.root_.ipAddressTableSm,
                                  self.intfStatus_, self.routingVrfConfigDir_,
                                  self.routing6VrfConfigDir_,
                                  self.routingVrfInfoDir_, self.routing6VrfInfoDir_, 
                                  self.vrfMibsDir_,
                                  self.root_.vrfRootDir, self.allVrfStatusLocal_,
                                  self.allVrfStatusGlobal_,
                                  self.allVrfConfig_, self.snmpStatus_, ipVrfMib,
                                  self.entityManager_.cEntityManager(),
                                  self.arpSmash_, self.root_.arpTableSm,
                                  self.root_.ipRouteTableSm,
                                  self.vrfIdStatus_, self.vrfNameStatus_, ifMib,
                                  localForwardingFecs, self.routeTablesEnabled_ )
         self.root_.vrfIfTableSm = ( ipVrfMib, self.intfStatus_, self.ipConfig_, 
                                     self.ip6Config_ )
         self.nhgRoot_ = snmpAgentRoot.newEntity( 'NexthopGroupSnmp::Agent::Root',
                                                  'NexthopGroupSnmp' )
         self.nhgRoot_.agent = ( nexthopGroupMib, self.tunnelCounterStatus_,
                                 self.snapShotCounterStatus_,
                                 self.smashNhgStatus_,
                                 self.nexthopGroupCounterKeyStatus,
                                 nexthopGroupConfigInput )
         agent = self.nhgRoot_.agent
         if NhgToggle.toggleNhgCliDynamicMergeSmEnabled():
            agent.nexthopGroupCliDynamicConfigMergeSm = ( agent.config,
                                                          nexthopGroupCliConfig,
                                                          nexthopGroupConfigInput )
         else:
            agent.nexthopGroupConfigMergeSm = ( agent.config,
                                                nexthopGroupCliConfig,
                                                nexthopGroupConfigInput )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   IraSnmpPlugin( ctx )
   Tac.dlopen( 'libIraSnmp.so' )
   Tac.dlopen( 'libNexthopGroupSnmp.so' )
