# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac, Tracing
import SharedMem
import Smash
import Plugins

t0 = Tracing.trace0

class IgmpSnmpPlugin( object ):
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      sysdb = entityManager.root()

      mg = entityManager.mountGroup()
      igmpConfig =  mg.mount( 'routing/igmp/config',
                              'Routing::Igmp::Config', 'r' )
      allIntfStatusDir = mg.mount( 'interface/status/all',
                                   'Interface::AllIntfStatusDir', 'r' )
      snmpRoot = sysdb.parent[ 'snmp' ]
      igmpRoot = snmpRoot.mkdir( 'igmp' )
      igmpMib = igmpRoot.newEntity( 'IgmpSnmp::IgmpStdMib', 'snmpIgmpMIB' )
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      self.root_ = None
      
      #Constants
      maxGroups = 2000
      maxIntfs = 511
      
      shmemEm = SharedMem.entityManager( sysdbEm=entityManager )
      igmpSmashStatus = shmemEm.doMount(
            'routing/igmp/status',
            'Igmp::Smash::Status',
            Smash.mountInfo( 'keyshadow',
               [ ( 'groupRecord', maxGroups * maxIntfs ), 
                  ( 'sourceRecord', maxGroups * maxIntfs ), 
                  ( 'querierStatisticsRecord', maxIntfs ),
                  ( 'packetStatisticsRecord', maxIntfs ) ] ) )

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'IgmpSnmpSm::Root',
                                               'igmpSnmpSmRoot' )
         self.root_.allIntfStatusDir = allIntfStatusDir
         self.root_.ifMib = ifMib
         self.root_.igmpConfig = igmpConfig
         self.root_.igmpSmashStatus = igmpSmashStatus
         self.root_.igmpMib = igmpMib
         self.root_.igmpSnmpStatsDirSm = ( self.root_.ifMib,
                                        self.root_.igmpConfig,
                                        self.root_.igmpSmashStatus, 
                                        self.root_.igmpMib )
         self.root_.igmpSnmpCacheSm = ( self.root_.allIntfStatusDir, 
               self.root_.igmpSmashStatus, 
               self.root_.igmpMib )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/intf', ) )
def Plugin( ctx ):
   t0( 'Loading Igmp Snmp Plugin' )
   IgmpSnmpPlugin( ctx )
   Tac.dlopen( 'libIgmpSnmp.so' )
