# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing

traceHandle = Tracing.Handle( 'Snmp' )
t0 = traceHandle.trace0

DeviceTableEntry = Tac.Type( "HostResources::DeviceTableEntry" )

def populateHostResourcesDeviceTable( deviceTable ):
   status = 2 # ( running )
   deviceType = ".1.3.6.1.2.1.25.3.1.3" # ( hrDeviceProcessor )

   descr = 'Default CPU - info not found in /proc/cpuinfo'
   numberCores = 1

   fileContent = open( '/proc/cpuinfo', 'r' ).readlines()

   # Find the cpu model name in /proc/cpuinfo
   for line in fileContent:
      if line.startswith( "model name" ):
         fields = line.split( ": " )
         descr = fields[ 1 ].strip()
         break

   # Find the number of cores in /proc/cpuinfo
   numberCores = 0
   for line in fileContent:
      if line.startswith( "core id" ):
         numberCores += 1

   # Add the main processor at index 1
   device = DeviceTableEntry( 1, deviceType, descr, status )
   deviceTable.addMember( device )

   # Add all the cores starting at index 2
   for coreIndex in range( 2, numberCores + 2 ):
      descr = "Core %d" % ( coreIndex - 1 )
      device = DeviceTableEntry( coreIndex, deviceType, descr, status )
      deviceTable.addMember( device )

   t0( "populated HostResourcesMib hrDeviceTable" )

def Plugin( ctx ):
   global processorTableSm # pylint: disable-msg=W0601
   t0( "SnmpHostResourcesMIB plugin loading..." )
   entityManager = ctx.entityManager()

   sysdb = entityManager.root()
   snmpRoot = sysdb.parent[ 'snmp' ]
   mib = snmpRoot.newEntity( 'HostResources::Mib', 'hostResources' )

   deviceTable = snmpRoot[ 'hostResources' ].deviceTable
   populateHostResourcesDeviceTable( deviceTable )

   processorTableSm = Tac.newInstance( 'HostResources::ProcessorTableSm', 
                                       Tac.activityManager.clock, mib )
    
