# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=W0603
# pylint: disable-msg=W0401
# pylint: disable-msg=W0602

import Plugins
import Tac, Tracing, Cell
from Snmp import addStage2MountFunction
from SnmpPlugin.XcvrAllStatusDir import xcvrAllStatusDirSysdbPath

# Creates dependency on IntfSnmp
# pkgdeps: import SnmpPlugin.IntfSnmp

snmpReactors = []
hardwareEntmib = None

traceHandle = Tracing.Handle( 'FruSnmp' )
#pylint: disable-msg=E1101
t0 = traceHandle.trace0

class RedundancyReactor( Tac.Notifiee ):
   notifierTypeName = 'Election::Status'
   def __init__( self, status, agent ):
      Tac.Notifiee.__init__( self, status )
      agent.handleRedundancy( status )
      t0( "RedundancyReactor created" )


class EntityMibStatusReactor( Tac.Notifiee ):
   notifierTypeName = 'EntityMib::Status'
   def __init__( self, hwEntitymib, entityManager, snmpEntityMib, stateMib,
                 sensorMib, fruSensors ):
      Tac.Notifiee.__init__( self, hwEntitymib )
      self.entityManager_ = entityManager
      self.entityMib = snmpEntityMib
      self.stateMib = stateMib
      self.sensorMib = sensorMib
      self.fruSensors = fruSensors
      self.xgc = None
      self.xcvrAllStatusDir = None
      self.intfStatusDir = None
      self.intfConfigDir = None
      self.coolingConfig = None
      self.archerCoolingStatus = None
      self.archerPowerStatus = None
      self.archerCellVoltageStatus = None
      self.archerSystemVoltageStatus = None
      self.archerCurrentStatus = None
      self.powerConfig = None
      self.archerCellTempStatus = None
      self.archerSystemTempStatus = None
      self.tempConfig = None
      self.cardStatus = None
      self.redundancy = None
      self.handleRoot()

   # Initialize FruSnmp data structures once hardare/entmib knows which
   # system (fixed or modular) it is.
   @Tac.handler( 'root' )
   def handleRoot( self ):
      if self.notifier_.root is None:
         return
      
      systemType = self.notifier_.root.tacType.fullTypeName
      if systemType not in [ 'EntityMib::Chassis', 'EntityMib::FixedSystem' ]:
         raise Exception( "Unknown system type %s" % systemType )
   

      mg = self.entityManager_.mountGroup()   
      self.intfConfigDir = mg.mount(
         'interface/config/all', 'Interface::AllIntfConfigDir', 'r' )
      self.xgc = mg.mount( 'hardware/xcvr/xgc', 'Xcvr::Xgc', 'r' )
      self.intfStatusDir = mg.mount(
         'interface/status/all', 'Interface::AllIntfStatusDir', 'r' )
      self.coolingConfig = mg.mount(
         'environment/cooling/config', 'Environment::Cooling::Config', 'r' )
      self.archerCoolingStatus = mg.mount(
         'environment/archer/cooling/status', 'Tac::Dir', 'ri' )
      self.archerPowerStatus = mg.mount(
         'environment/archer/power/status/powerSupply', 'Tac::Dir', 'ri' )
      self.archerCellVoltageStatus = mg.mount(
         'environment/archer/power/status/voltageSensor/cell', 'Tac::Dir', 'ri' )
      self.archerSystemVoltageStatus = mg.mount(
         'environment/archer/power/status/voltageSensor/system', 'Tac::Dir', 'ri' )
      self.archerCurrentStatus = mg.mount(
         'environment/archer/power/status/currentSensor', 'Tac::Dir', 'ri' )
      self.powerConfig = mg.mount(
         'environment/power/config', 'Environment::Power::Config' , 'r')
      self.archerCellTempStatus = mg.mount(
         'environment/archer/temperature/status/cell', 'Tac::Dir', 'ri' )
      self.archerSystemTempStatus = mg.mount(
         'environment/archer/temperature/status/system', 'Tac::Dir', 'ri' )
      self.tempConfig = mg.mount(
         'environment/temperature/config', 'Environment::Temperature::Config', 'r' )
      self.cardStatus = mg.mount(
         'hardware/card/status', 'Hardware::Card::Status', 'r' )

      if "Chassis" in systemType:
         # First mount only the Dir. Because some test programs do not
         # instantiate redundancy status entitities for chassis.
         self.redundancy = mg.mount(
               Cell.path( 'redundancy/election' ), 'Tac::Dir', 'r' )
      else :
         self.redundancy = None

      def finishMonitorMounts():
         t0( "finishMonitorMounts" )

         sysdb = self.entityManager_.root()
         snmpAgentRoot = sysdb.parent[ 'Snmp' ]
         self.xcvrAllStatusDir = snmpAgentRoot[ 'XcvrAllNewStatusDir' ]

         agent = snmpAgentRoot.newEntity( 'FruSnmp::Root', 'FruSnmpRoot' )
         agent.entityMib = self.entityMib
         agent.sensorMib = self.sensorMib
         agent.stateMib = self.stateMib
         agent.fruSensors = self.fruSensors
         agent.status = hardwareEntmib
         agent.xcvrStatusDir = self.xcvrAllStatusDir
         agent.xgc = self.xgc
         agent.intfStatusDir = self.intfStatusDir
         agent.intfConfigDir = self.intfConfigDir
         agent.coolingConfig = self.coolingConfig
         agent.archerCoolingStatus = self.archerCoolingStatus
         agent.archerPowerStatus = self.archerPowerStatus
         agent.archerCellVoltageStatus = self.archerCellVoltageStatus
         agent.archerSystemVoltageStatus = self.archerSystemVoltageStatus
         agent.archerCurrentStatus = self.archerCurrentStatus
         agent.powerConfig = self.powerConfig
         agent.archerCellTempStatus = self.archerCellTempStatus
         agent.archerSystemTempStatus = self.archerSystemTempStatus
         agent.tempConfig = self.tempConfig
         agent.cardStatus = self.cardStatus
         agent.redundancy = self.redundancy
         agent.handleInitialized()

         if self.redundancy is not None:
            
            if "status" in self.redundancy:
               mg = self.entityManager_.mountGroup()
               status = mg.mount( Cell.path( 'redundancy/election/status' ),
                                  'Election::Status', 'r' )
               mg.close( lambda : snmpReactors.append( 
                  RedundancyReactor( status, agent ) ) )
      
      mg.close( finishMonitorMounts )
      t0( 'FruSnmp Plugin initialized' )

#-----------------------------------------------------------------------------
# Plugin
#-----------------------------------------------------------------------------
@Plugins.plugin( requires=( 'snmp/intf', xcvrAllStatusDirSysdbPath ),
                 provides=( 'Snmp/FruSnmpSensors', ) )
def Plugin( ctx ):
   t0( 'FruSnmp Plugin Loading...' )
   entityManager = ctx.entityManager()
   
   root = entityManager.root().parent[ 'snmp' ]
   rootDir = root.mkdir( 'fru' )
   entityMib = rootDir.newEntity( 'FruSnmp::FruSnmpEntityMib', 'entitymib' )
   rootDir = root.mkdir( 'state' )
   stateMib = rootDir.newEntity( 'FruSnmp::FruSnmpStateMib', 
            'entitystatemib' )
   rootDir = root.mkdir( 'sensor' )
   sensorMib = rootDir.newEntity( 'FruSnmp::FruSnmpSensorMib', 
            'entitysensormib' )

   # Some sensors are not based on entries in EntityMib, create a location for
   # collections of these sensors
   snmpAgentRoot = entityManager.root().parent[ 'Snmp' ]
   fruSensors = snmpAgentRoot.newEntity( 'FruSnmp::FruSnmpGenericSensors',
                                         'FruSnmpSensors' )

   def _callback():
      global snmpReactors, hardwareEntmib
      mg = entityManager.mountGroup()
      hardwareEntmib = mg.mount( 'hardware/entmib', 'EntityMib::Status', 'r' )
      mg.close( lambda : snmpReactors.append(
            EntityMibStatusReactor( hardwareEntmib, entityManager,
            entityMib, stateMib, sensorMib, fruSensors ) ) )
   addStage2MountFunction( _callback )
