# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing

traceHandle = Tracing.Handle( 'FhrpSnmp' )

t0 = traceHandle.trace0

class FhrpSnmpPlugin( object ):
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      vrrpDir = snmpRoot.mkdir( 'vrrp' )
      vrrpMib = vrrpDir.newEntity( 'FhrpSnmp::VrrpMib', 'vrrpMIB' )

      mg = entityManager.mountGroup()
      self.fhrpConfig_ = mg.mount( 'routing/fhrp/config',
                                   'Routing::Fhrp::Config', 'r' )
      self.fhrpStatus_ = mg.mount( 'routing/fhrp/status',
                                   'Routing::Fhrp::StatusV4', 'r' )
      self.intfStatus_ = mg.mount( 'interface/status/all',
                                   'Interface::AllIntfStatusDir', 'r' )
      Tac.Type( "Ira::IraIpStatusMounter" ).doMountEntities( mg.cMg_, True, False )
      # Retain this call for assignment purpose
      self.ipStatus_ = mg.mount( 'ip/status', 'Ip::Status', 'r' )
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'FhrpSnmp::Agent', 'FhrpSnmp' )
         self.root_.vrrpMib = vrrpMib
         self.root_.vrrpMibSm = ( self.fhrpConfig_, self.fhrpStatus_,
                                  self.intfStatus_, self.ipStatus_, vrrpMib )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   t0( 'VrrpMib plugin loading...' )
   FhrpSnmpPlugin( ctx )
   Tac.dlopen( 'libFhrpSnmp.so' )
