# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, SharedMem, Smash

class QBridgeSnmpPlugin( object ):
   def __init__( self, ctx ):
      self.root_ = None
      self.entityManager_ = ctx.entityManager()
      self.ctx_ = ctx
      sysdb = self.entityManager_.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      ebraDir = snmpRoot.mkdir( 'ebra' )
      mibEntity = ebraDir.newEntity( 'BridgeSnmp::QBridgeMib',
                                       'qbridgemib' )
      mg = self.entityManager_.mountGroup()
      # Avoid implicit mount by explicitly mount here
      # See Ebra/SysdbMountProfiles/Ebra-IntfStatus-deps-include
      mg.mount( 'interface/input/dynvlanintf', 'Tac::Dir', 'ri' )
      bridgeConfig = mg.mount( 'bridging/config', 'Bridging::Config', 'r' )
      vlanStatus = mg.mount( 'bridging/vlan/status',
                             'Bridging::VlanStatusDir', 'r' )
      intfStatus = mg.mount( 'interface/status/eth/intf',
                             'Interface::EthIntfStatusDir', 'r' )
      cliConfig = mg.mount( 'bridging/input/config/cli',
                            'Bridging::Input::CliConfig', 'w' )
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      scheduler = snmpAgentRoot[ 'root' ].scheduler

      def _finishMounts():
         macAddressTablesEnabled = True
         if not self.ctx_.objectsDisabled( 'mac-address-tables' ):
            # mount the Smash::Bridging::Status entity as a shadow to get
            # notifications from shared memory, and populate a local
            # Bridging::Status singleton
            shmemEm = SharedMem.entityManager( sysdbEm=self.entityManager_ )
            smi = Smash.mountInfo( 'shadow' )
            smashBridgeStatus = shmemEm.doMount( 'bridging/status',
                                                 'Smash::Bridging::Status', smi )
            bridgeStatus = Tac.singleton( 'Bridging::Status' )
            shim = Tac.Type( 'Bridging::ReaderFdbStatusSm' )(
               bridgeStatus, smashBridgeStatus )
         else:
            bridgeStatus = None
            shim = None
            macAddressTablesEnabled = False

         self.root_ = snmpAgentRoot.newEntity( 'BridgeSnmpAgent::Agent', 
                                               'BridgeSnmp' )
         self.root_.config = bridgeConfig
         self.root_.status = bridgeStatus
         self.root_.vlanStatusDir = vlanStatus
         self.root_.intfStatusDir = intfStatus
         self.root_.scheduler = scheduler
         self.root_.macAddressTablesEnabled = macAddressTablesEnabled
         # BridgeSnmpAgent instantiates reactors once you set mib,
         # so make sure state is set before now.
         self.root_.mib = mibEntity
         self.root_.mib.config = bridgeConfig
         self.root_.mib.inputConfig = cliConfig
         self.root_.mib.status = bridgeStatus
         # The readerShim is stored here to keep a smart pointer alive.
         self.root_.readerShim = shim

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   QBridgeSnmpPlugin( ctx )
