# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac, Tracing, Cell
# pkgdeps: import DefaultConfigPlugin.GatedSnmp

traceHandle = Tracing.Handle( 'BgpSnmp' )
t0 = traceHandle.trace0
t1 = traceHandle.trace1


class BgpSnmpPlugin( object ):
   def __init__( self, ctx ):
      self.root_ = None
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      self.entityManager_ = entityManager
      bgpPeerExportInfo = 'routing/bgp/export/vrfBgpPeerInfoStatusEntryTable'
      self.bgpPeerExportInfo_ = mg.mount( bgpPeerExportInfo,
                                         'Tac::Dir',
                                         'ri' )
      bgpGlobalExportInfo = 'routing/bgp/export/vrfBgpGlobalInfoStatus'
      self.bgpGlobalExportInfo_ = mg.mount( bgpGlobalExportInfo,
                                            'Tac::Dir',
                                            'ri' )
      self.l3Config_ = mg.mount( 'l3/config',
                                 'L3::Config',
                                 'r' )
      self.defaultVrfProtocolStatusDir_ = mg.mount(
         Cell.path( 'routing/defaultVrfProtocolStatus' ),
         'Tac::Dir',
         'ri' )
      self.trapStatus_ = mg.mount( 'snmp/bgp/status',
                                   'BgpSnmp::BgpSnmpTrapStatus',
                                   'w' )
      sysdb = entityManager.root()
      self.snmpStatus_ = sysdb[ 'snmp' ][ 'status' ]
      snmpRoot = sysdb.parent[ 'snmp' ]
      self.bgpMibRoot_ = snmpRoot.mkdir( 'bgp' )
      self.version_ = self.bgpMibRoot_.newEntity( 'BgpSnmp::BgpVersion', 'version' )
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'BgpSnmp::BgpRoot', 'BgpSnmp' )
         self.root_.bgpRootSm = ( self.entityManager_.cEntityManager(),
                                  self.bgpMibRoot_,
                                  self.bgpPeerExportInfo_,
                                  self.bgpGlobalExportInfo_,
                                  self.l3Config_,
                                  self.snmpStatus_,
                                  self.defaultVrfProtocolStatusDir_,
                                  self.trapStatus_ )
      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   t0( 'BgpSnmp Plugin Loading...' )
   BgpSnmpPlugin( ctx )
   Tac.dlopen( 'libBgpSnmp.so' )
