#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing
traceHandle = Tracing.Handle( 'AleCapacitySnmp' )
t0 = traceHandle.trace0

class AleCapacitySnmpPlugin( object ):
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      capacityMibDir = snmpRoot.mkdir( 'capacity' )
      aleCapacityMib = capacityMibDir.newEntity( 'AleCapacitySnmp::CapacityTableMib',
                                                 'capacityMib' )
      mg = entityManager.mountGroup()
      self.statusDir_ = mg.mount( 'hardware/capacity/status', 'Tac::Dir', 'ri' )
      self.config_ = mg.mount( 'hardware/capacity/config',
                               'AleCapacity::TableThreshold', 'ri' )
      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None
      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'AleCapacitySnmp::Root', 
                                               'AleCapacitySnmp' )
         self.root_.capacityConfig = self.config_
         self.root_.capacityStatusDir = self.statusDir_
         self.root_.capacityMib = aleCapacityMib
         self.root_.capacityMibSm = ( self.config_, self.statusDir_, aleCapacityMib )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )
      
def Plugin( ctx ):
   t0( "AleCapacityMib plugin loading..." )
   AleCapacitySnmpPlugin( ctx )
   Tac.dlopen( "libAleCapacitySnmp.so" )

