#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing

traceHandle = Tracing.Handle( 'AclSnmp' )
t0 = traceHandle.trace0

class AclSnmpPlugin( object ):
   def __init__( self, ctx ):
      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      aclMibDir = snmpRoot.mkdir( 'acl' )
      aclMib = aclMibDir.newEntity( 'AclSnmp::AclMib', 'aclMIB' )
      mg = entityManager.mountGroup()
      self.aclConfig_ = Tac.newInstance( "Acl::Config" ) 
      self.aclConfigDir_ = mg.mount( 'acl/config/input', 'Tac::Dir', 'ri' )
      self.cliAclConfig_ = mg.mount( 'acl/config/cli', 'Acl::Input::Config', 'r' )
      self.aclStatus_ = mg.mount( 'acl/status/all', 'Acl::Status', 'r' )

      snmpAgentRoot = sysdb.parent[ 'Snmp' ]
      scheduler = snmpAgentRoot[ 'root' ].scheduler
      self.root_ = None

      def _finishMounts():
         self.root_ = snmpAgentRoot.newEntity( 'AclSnmp::Root', 'AclSnmp' )
         self.root_.aclConfig = self.aclConfig_
         self.root_.aclConfigAggregator = ( self.aclConfigDir_, self.cliAclConfig_,
                                            self.aclConfig_ )
         self.root_.aclStatus = self.aclStatus_
         self.root_.aclMib = aclMib
         self.root_.aclMibSm = ( scheduler, self.aclConfig_, self.aclStatus_,
                                 aclMib )
      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

def Plugin( ctx ):
   t0( "AclMib plugin loading..." )
   AclSnmpPlugin( ctx )
   Tac.dlopen( "libAclSnmp.so" )
