#!/usr/bin/env python
# Copyright (c) 2008 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ctypes import c_int32
import re

# PEN assigned to Arista Networks by IANA; see AID 285.
aristaPen = 30065

def objectIdFromModelName( modelName ):
   """Generates the sysObjectID value from a model name."""
   if modelName == "":
      return "0.0"
   oidPrefix = "1.3.6.1.4.1.%d.1" % aristaPen
   oid = oidPrefix.split( "." )
   components = re.findall( "(0+|[1-9]\d*|[A-Za-z]+)", modelName )
   for c in components:
      if re.match( "[1-9]", c ):
         oid.append( c )
      else:
         # oid components are ints, so hash the string to a 12-bit int
         oid.append( str( abs( _stringHash( c ) ) % 4096 ) )
   objectId = ".".join( oid )
   return objectId
def _stringHash( s ):
   # This is ported from Python's implementation of string_hash() in 2.7.16,
   # as executed on i386, in order to provide results consistent with that
   # implementation, even if Python changes its implementation in the future.
   ln = len( s )
   if ln == 0:
      return 0

   x = c_int32( ord( s[ 0 ] ) << 7 )
   i = 0
   while ln >= 1:
      ln -= 1
      x.value *= 1000003
      x.value ^= ord( s[ i ] )
      i += 1
   x.value ^= len( s )
   if x.value == -1:
      return -2
   return x.value
