#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

#
# This file contains Smash APIs for EOS product code.
#

def mountInfo( mode, collectionInfo=None, cleanup=False, shrinkSlots=True,
               shrinkBuckets=True, pruneConquer=True, notifyFlush=True,
               heapCheckEnabled=False, assertOnOrphanAccess=None ):
   """Returns a MountInfo object with the given Smash-specific information."""
   mi = Tac.Value( 'TacSmash::MountInfo', mode )

   if collectionInfo:
      for ( name, size ) in collectionInfo:
         tableInfo = Tac.Value( 'TacSmash::CollectionInfo', name, size )
         mi.collectionInfo.addMember( tableInfo )

   mi.cleanup = cleanup
   mi.shrinkSlots = shrinkSlots
   mi.shrinkBuckets = shrinkBuckets
   mi.pruneConquer = pruneConquer
   mi.notifyFlush = notifyFlush
   mi.heapCheckEnabled = heapCheckEnabled

   if assertOnOrphanAccess is not None:
      mi.assertOnOrphanAccess = assertOnOrphanAccess

   return mi

def rootPath():
   """Returns the path where Smash files are located in the filesystem."""
   return Tac.newInstance( 'TacSmash::RootPath', '', False ).rootPath
