#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Tac

#
# This file contains Shark APIs for EOS product code.
#

def mountInfo( mode, cleanup=False ):
   """Returns a MountInfo object with the given Shark-specific information."""
   mi = Tac.Value( 'TacShark::MountInfo', mode )
   mi.cleanup = cleanup

   return mi

def rootPath():
   """Returns the path where Shark files are located in the filesystem."""
   return Tac.newInstance( 'TacShark::RootPath', '', False ).rootPath
