# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType
import Tac

# pkgdeps: rpm IntfSnmp-lib
IntfDetails = TacLazyType( 'IntfSnmp::IntfDetails' )
# pkgdeps: rpm Arnet-lib
IpGenAddr = TacLazyType( 'Arnet::IpGenAddr' )

def ifindexToIntf( ifIndexMap, ifindex ):
   return Tac.Value( 'Arnet::IntfId', ifIndexMap.get( ifindex, '' ) )

def valueOrUnknown( value ):
   if isinstance( value, IpGenAddr ) :
      return "unknown" if value.isAddrZero else value.stringValue
   else:
      return value if value else "unknown"

def vniOrUnknown( value ):
   vniInvalid = 4294967295
   if value == vniInvalid:
      return "unknown"
   else:
      return str( value )
