#!/usr/bin/env python
# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

SFLOW_TRUNCATION_SIZE = 128

# Default sFlow IP/Port
defaultPort = 6343
defaultIp = '0.0.0.0'
defaultIp6 = '::'
minPort = 1
maxPort = ( 1 << 16 ) - 1

# default state
samplingEnabledDefault = True

# polling-interval
defaultPollingInterval = 2
minPollingInterval = 1
maxPollingInterval = 3600

# sample rate
defaultSampleRate = ( 1 << 20 )
minSampleRate = ( 1 << 14 )
maxSampleRate = ( 1 << 24 )
dangMinSampleRate = 1
dangMaxSampleRate = ( 1 << 32 ) - 1

# Printing helper method for outputing "(Default)" next
# to a value that matches the default value
def valueWithDefaultInd( value, default ):
   if ( value == default ):
      return "%s (default)" % value
   else:
      return "%s" % value


# Added when I didn't know how to use the FocalPoint API properly,
# now might as well leave this here in case we ever want to revoke
# the ability to support LAGs.
# Can also modify Sflow::EthIntfStatusSm::handleIntfStatusChange().
LAG_SUPPORT = True

sflowSourceDefaultMsg = "Sources: None (default)"
sflowDestDefaultMsg = "Destinations: None (default)"
sflowDest6DefaultMsg = "Destinations (IPv6): None (default)"

SFLOWACCEL1MODE = 1
SFLOWACCEL2MODE = 2

SFLOW_UNKNOWN_INTERFACE = 0
SFLOW_INTERNAL_INTERFACE = 0x3FFFFFFF
SFLOW_DISCARD_REASON_TTL_EXCEEDED = 257
SFLOW_FORMAT_SINGLE = 0
SFLOW_FORMAT_DISCARD = 1
SFLOW_FORMAT_MULTIPLE = 2
