# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

class ServicePluginContext( object ):
   def __init__( self, serviceConfigDir, serviceStatusDir=None ):
      self.serviceConfigDir_ = serviceConfigDir
      self.serviceStatusDir_ = serviceStatusDir

   def addServiceAndVersion( self, name, versionWithDescs, enabled ):
      service = self.serviceConfigDir_.newService( name )
      service.versionConfig = ( name + "VersionConfig", )
      versionConfig = service.versionConfig
      for version, desc in versionWithDescs:
         serviceVersion = Tac.Value( "Controller::ServiceVersionV1", version )
         serviceVersion.desc = desc
         versionConfig.version.addMember( serviceVersion )
      service.enabled = enabled

def addServiceInfo( servicePluginCtx, serviceName, versionWithDescs, enabled=False ):
   servicePluginCtx.addServiceAndVersion( serviceName, versionWithDescs, enabled )
