# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

def dictToTaccForCli( entityDict, tacEntity ):
   '''Simultaneously checks whether dictionary and entity attributes match
      and if they don't, sets tacEntity to values in entityDict
      entityDict { 'attributeName' : attributeValue,
                   'collectionName' : [ ( key, val ) },
                   'subEntityName : { ... } '''
   changed = False
   # pylint: disable-msg=R1702, too-many-nested-blocks
   if entityDict and entityDict:
      for attr, val in entityDict.iteritems():
         if isinstance( val, list ):
            collection = getattr( tacEntity, attr )
            stateKeys = []
            if len( val ) != len( collection ):
               changed = True
            if not val:
               collection.clear()
               continue
            assert isinstance( val[ 0 ], tuple )
            for k, v in val:
               if k not in collection or collection[ k ] != v:
                  changed = True
                  collection[ k ] = v
               stateKeys.append( k )
            for k in collection:
               if k not in stateKeys:
                  changed = True
                  del collection[ k ]
         elif getattr( tacEntity, attr ) != val:
            changed = True
            setattr( tacEntity, attr, val )
   return changed

def bandwidthHumanReadable( bandwidth ):
   ''' Convert bandwidth value to human readable format (bps/kbps/mbps/gbps).
   '''
   unit = "bps"
   bw = bandwidth
   if bw > 1e3:
      bw /= 1e3
      unit = "kbps"
      if bw > 1e3:
         unit = "mbps"
         bw /= 1e3
         if bw > 1e3:
            unit = "gbps"
            bw /= 1e3
   return ( bw, unit )

def bandwidthBitsToBytes( bits ):
   if bits > 1000:
      # Our CLI precision is %.2f, so round up the bits to the nearest
      # multiple of 40 (because LCM( 8, 10 ) is 40)
      # then divide by 8 to convert to bytes
      return ( ( bits + 39 ) // 40 ) * 5
   else:
      # simply round up to the next multiple of 8 and divide by 8
      return ( bits + 7 ) // 8
