#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from Bunch import Bunch
import Tac

class RouteFec( Bunch ):
   """Represents one FEC parsed from output of 'show ip|ipv6 route [vrf <name>]
   <prefix> fec"""

   def __init__( self, **kwargs ):
      Bunch.__init__( self, **kwargs )
      self.fecId = long( self.fecId )
      self.vias = []

class RouteVia( Bunch ):
   """Represents one via in output of show ip|ipv6 route ..."""

   def __init__( self, **kwargs ):
      Bunch.__init__( self, **kwargs )

   def __eq__( self, other ):
      if not isinstance( other, RouteVia ):
         return NotImplemented
      return self.nexthop == other.nexthop and \
         self.interface == other.nexthop

   def __ne__( self, other ):
      return not self.__eq__( other )

def getUrpfGlobalHwStatus( urpfHwStatusDir ):
   """
   Analyzes the urpfHwStatusDir input argument that is a Tac::Dir
   where each entry is keyed by slice name and whose value is a
   Routing::UrpfHwStatus object, and returns the global status.
   """
   urpfStatus = Tac.Type( 'Urpf::UrpfState' )
   # global status is -
   #      errDisabled if any of the slice's status is errDisabled
   #      disabled if any slice's status is disabled but none is errDisabled
   #      enabled only if all status is enabled
   globalStatus = urpfStatus.urpfEnabled
   for sliceUrpfHwStatus in urpfHwStatusDir.itervalues():
      if sliceUrpfHwStatus.status == urpfStatus.urpfErrorDisabled:
         globalStatus = urpfStatus.urpfErrorDisabled
         break
      elif sliceUrpfHwStatus.status == urpfStatus.urpfDisabled:
         globalStatus = urpfStatus.urpfDisabled
   return globalStatus
