# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import re

def checkPdpConfig( ctx ):
   '''Check startup-config and see if there are PDP service-policy
   configuration, if so, add warning message indicating PDP policy is
   ignored.
   '''
   startupConfigPath = '/mnt/flash/startup-config'
   if 'SIMULATION_VMID' in os.environ:
      startupConfigPath = '/tmp/pdp-startup-config'
   pdpPolicyMaps = []
   pdpServicePolicyPat = r'service-policy type pdp input\s+(\S*)\s*$'
   if os.path.isfile( startupConfigPath ):
      with open( startupConfigPath ) as f:
         for line in f:
            m = re.search( pdpServicePolicyPat, line )
            if m:
               pdpPolicy = m.group( 1 )
               if pdpPolicy not in pdpPolicyMaps:
                  pdpPolicyMaps.append( pdpPolicy )
   for pdpPolicy in pdpPolicyMaps:
      ctx.addWarning( "PDP policy: %s in startup-config is ignored" % pdpPolicy )
   return True

def Plugin( ctx ):
   categories = [ 'ASU', 'ASU+', 'General' ]
   ctx.addPolicy( checkPdpConfig, categories )
