# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os

resetCauses = [
   'cpuCatErrFault',
   'cpuSlpS3Fault',
   'cpuThermTripFault',
   'dpmSeuError',
   'fansMissing',
   'fastReboot',
   'fatalError',
   'hitlessReload',
   'internalRail',
   'kernel',
   'overTemp',
   'pluto',
   'plxError',
   'powerLoss',
   'procError',
   'cpuMachineCheck',
   'psuFault',
   'scdSeuError',
   'cpldSeuError',
   'thermo',
   'unknown',
   'userReload',
   'watchdog',
   'switchChipPowerLoss',
   'portModulePowerLoss',
   'switchChipPciError',
   'cardUnseated',
   'rearCardFault', 
]

# XXX_APECH This constant should live elsewhere and be shared with Thermostat.py...
flashDir = os.path.join( os.environ.get( "FILESYSTEM_ROOT", "/mnt" ),
                         "flash" )
debugDir = os.path.join( flashDir, "debug" )

reloadDebugFile = os.path.join( debugDir, "local_reload_cause" )

kernelPanicFile = os.path.join( debugDir, 'kernelcrash' )
wDescription = 'The system rebooted due to a watchdog'
wkDescription = 'The system rebooted due to a watchdog caused by a kernel panic'
wuDescription = 'User-initiated reload interrupted by watchdog'
kDescription = 'The system rebooted due to a kernel panic'
kRecommendedAction = 'This may indicate a software or hardware problem.' \
                     '\nContact your customer support representative and provide ' \
                     'the contents \nof the "Debugging Information" below.'
wRecommendedAction = 'This may indicate a software or hardware problem.' \
                     '\nContact your customer support representative.'
noRecommendedAction = 'No action necessary.'
powerLossDescription = 'The system rebooted due to a Power Loss'
reloadDescription = 'Reload requested by the user.'
reloadTimeDescription = 'Reload occurred at'
switchoverDescription = 'Supervisor switchover.'
overTempDescription = 'Software shut down system due to critical system temperature'
thermoInsufficientFansDescription = 'Software shut down system due to' \
                                    ' insufficient fans'
fansMissingDescription = "The system rebooted as fans were not detected"
psuFaultDescription = "The system rebooted due to a PSU fault not caused by mains " \
                      "failure"
cpuSlpS3FaultDescription = "The system rebooted due to a CPU S3 sleep state fault"
cpuThermTripFaultDescription = "The system rebooted due to a CPU thermal fault"
cpuCatErrFaultDescription = "The system rebooted due to a CPU CATERR fault"
plxErrorDescription = "The system rebooted due to a PLX fatal error"
scdSeuErrorDescription = "The system rebooted due to an SEU error on the Scd"
dpmSeuErrorDescription = "The system rebooted due to an SEU error on the Dpm"
procErrorDescription = "The system rebooted due to a processor fatal error"
cpuMachineCheckDescription = "The system rebooted due to a CPU machine check "\
                             "exception."
cpldSeuErrorDescription = "The system rebooted due to an SEU error on the Cpld"
switchChipPowerLossDescription = "The system rebooted due to power loss on the " \
                                 "switching chip."
switchChipPciErrorDescription = "The system rebooted due to a PCI error in the " \
                                "switching ASIC."
portModulePowerLossDescription = "The system rebooted due to a power event in " \
                                 "a port module."
cardUnseatedDescription = "The system rebooted due to a card being unseated"
reopeninternalRailFailure = "The system rebooted due to an internal rail failure"
internalRailFailure = "The system rebooted due to an internal rail failure"
internalRailRecommendedAction = \
    'Software detected that the switch rebooted due to an internal rail failure.' \
    '\nIf the problem persists, contact your customer support representative.'
softwareReloadDescription = "Reload requested by software"
unknownError = "The system rebooted due to unknown reasons."

overTempRecommendedAction = "Software detected that the switch started" \
   " overheating and "\
   "hence turned off POS12V causing the switch to restart. " \
   "\nIf the problem persists, contact your customer support representative."

thermoRecommendedAction = "If the system was shut down due to " \
   "insufficient or mismatched fans:" \
   "   * check you have properly installed fans with the same airflow direction." \
   "   * check that all fans are tightly screwed into place." \
   "   * replace all failed fans" \
   "If the system was shut down due to overtemperature:" \
   "   * check that all air vents are unobstructed." \
   "   * check that the switch is operating within its designed range of" \
   "0-40C ambient temperature." \
   "If the problem persists, contact your customer support representative."

scdSeuErrorRecommendedAction = \
   "Software detected that the switch rebooted due to an SEU error on the Scd." \
   "\nIf the problem persists, contact your customer support representative."

switchChipPowerLossRecommendedAction = \
   "Software detected a power event in a power supply that supplies the " \
   "switching chip." \
   "\nIf the problem persists, contact your customer support representative."

switchChipPciErrorRecommendedAction = \
   "Software detected a PCI error in the switching ASIC." \
   "\nIf the problem persists, contact your customer support representative."

portModulePowerLossRecommendedAction = \
   "Software detected a power event in a power supply that supplies the " \
   "port modules." \
   "\nIf the problem persists, contact your customer support representative."

plxErrorRecommendedAction = \
   "The system rebooted due to a PLX fatal error." \
   "\nIf the problem persists, contact your customer support representative."

procErrorRecommendedAction = \
   "The system rebooted due to a processor fatal error." \
   "\nIf the problem persists, contact your customer support representative."

cpuMachineCheckRecommendedAction = \
   "The CPU detected an internal error condition and reset the system." \
   "\nIf the problem persists, contact your customer support representative."

fatalErrorRecommendedAction = \
   "The system rebooted due to a fatal error." \
   "\nIf the problem persists, contact your customer support representative."

psuFaultRecommendedAction = \
   "The system rebooted due to a PSU fault not caused by mains failure." \
   "\nIf the problem persists, contact your customer support representative."

cpuSlpS3FaultRecommendedAction = \
   "The system rebooted due to a CPU S3 sleep state fault." \
   "\nIf the problem persists, contact your customer support representative."

cpuThermTripFaultRecommendedAction = \
   "The system rebooted due to a CPU thermal fault." \
   "\nIf the problem persists, contact your customer support representative."

cpuCatErrFaultRecommendedAction = \
   "The system rebooted due to a CPU CATERR error." \
   "\nIf the problem persists, contact your customer support representative."

cardUnseatedRecommendedAction = \
   "Check the card is firmly seated and the ejector handle is closed." \
   "\nIf the problem persists, contact your customer support representative."

rearCardFaultDescription = "The system rebooted due to a rear card fault."

rearCardFaultRecommendedAction = rearCardFaultDescription + \
   "\n If the problem persists, contact your customer support representative."
