#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

tacReflectorDirection = Tac.Type( "Reflector::Direction" )
tacReflectorMacAction = Tac.Type( "Reflector::MacAction" )
tacReflectorHwPrgmStatus = Tac.Type( "Reflector::HwPrgmStatus" )

# Map Reflector::Direction enum strings to CLI strings
directionStringToString = { 'directionEgress': 'out',
                            'directionIngress': 'in' }

# Map Reflector::Direction enum strings to CLI strings
macActionStringToString = { 'macActionSwap': 'swap' }

# Map CLI string to Reflector::Direction enum values
# Include mapping for None as a convenience for CLI no/default handling
stringToDirection = { None: tacReflectorDirection.directionNone,
                      'in': tacReflectorDirection.directionIngress,
                      'out': tacReflectorDirection.directionEgress }

# Map CLI string to Reflector::MacAction enum values
# Include mapping for None as a convenience for CLI no/default handling
stringToMacAction = { None: tacReflectorMacAction.macActionNone,
                      'swap': tacReflectorMacAction.macActionSwap }

# Map Reflector::Direction enum values to CLI strings
directionToString = { tacReflectorDirection.directionNone: 'not configured',
                      tacReflectorDirection.directionIngress: 'in',
                      tacReflectorDirection.directionEgress: 'out' }

# Map Reflector::MacAction enum values to CLI strings
macActionToString = { tacReflectorMacAction.macActionNone: 'not configured',
                      tacReflectorMacAction.macActionSwap: 'swap' }

# Map Reflector::HwPrgmStatus enum values to CLI strings
hwPrgmStatusToString = { tacReflectorHwPrgmStatus.hwPrgmFail: 'inactive',
                         tacReflectorHwPrgmStatus.hwPrgmSuccess: 'active' }
