# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

def collectionNameFromTypename( typename ):
   """Given an RCF typename, this function returns a name that can be used for a
   type member.  This is useful when figuring out the name of the member in
   AllAetEntities for a given AET Eval type.
   """
   def lowercase( string ):
      return string[ 0 ].lower() + string[ 1 : ]

   typenameWithoutNamespace = typename.split( '::' )[ -1 ]
   collName = '%sColl' % lowercase( typenameWithoutNamespace )

   return collName
