# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import syslog

import CliPlugin
import Tac
from Toggles.RcfLibToggleLib import toggleRcfAgentEnabled

class RcfConfigReactor( Tac.Notifiee ):
   notifierTypeName = "Rcf::Config"

   def __init__( self, notifier ):
      Tac.Notifiee.__init__( self, notifier )

   # if Sysdb rcfText changes, compile it in lax mode and commit to
   # AllFunctionStatus
   @Tac.handler( "rcfText" )
   def handleRcfTextChange( self ):
      compileResult = CliPlugin.RcfCli.compileRcfText( self.notifier_.rcfText,
                                                       False )
      if compileResult and compileResult.success:
         if not toggleRcfAgentEnabled():
            # When Rcf Agent is enabled, we don't need ConfigAgent to
            # publish anything in AllFunctionStatus.
            #
            # Also, not publishing AET from ConfigAgent when Rcf Agent toggle is
            # enabled is a good testing measure: Rcf Agent tests could be
            # unexpectedly if we're reading on the wrong agent2agent socket.
            compileResult.publish( CliPlugin.RcfCli.gv.rcfAllFunctionStatus,
                                   CliPlugin.RcfCli.gv.rcfStatus )
         CliPlugin.RcfCli.gv.rcfStatus.active = True
      else:
         errorStr = "\n".join( compileResult.errorList )
         syslog.openlog( 'Rcf' )
         syslog.syslog( errorStr )
         CliPlugin.RcfCli.gv.rcfStatus.active = False
