#!/usr/bin/env python
# Copyright (c) 2009, 2010, 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AaaCliLib
from RadiusConstants import ( # pylint: disable-msg=unused-import
      defaultPort,
      defaultAcctPort,
      defaultDynAuthPort,
      defaultInnerTunnelPort,
)

cliPortHelp = 'UDP port of RADIUS authentication server (default is %d)' % \
              defaultPort

cliAcctPortHelp = 'UDP port of RADIUS accounting server (default is %d)' % \
              defaultAcctPort

AaaCliLib.registerGroup( 'radius', 'radius', 'RADIUS',
                         AaaCliLib.AaaPortInfo(
                            'auth-port', cliPortHelp, defaultPort ),
                         AaaCliLib.AaaPortInfo(
                            'acct-port', cliAcctPortHelp, defaultAcctPort ),
                         AaaCliLib.ActionType.AUTHN |
                         AaaCliLib.ActionType.AUTHN_DOT1X |
                         AaaCliLib.ActionType.AUTHZ_EXEC |
                         AaaCliLib.ActionType.AUTHZ_COMMAND |
                         AaaCliLib.ActionType.ACCT_EXEC |
                         AaaCliLib.ActionType.ACCT_COMMAND |
                         AaaCliLib.ActionType.ACCT_SYSTEM |
                         AaaCliLib.ActionType.ACCT_DOT1X,
                         True )





