#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

tacTrafficClass = Tac.newInstance( "Qos::TrafficClass" )
tacDropPrecedence = Tac.newInstance( "Qos::DropPrecedence" )
tacTrustMode = Tac.Type( "Qos::TrustMode" )
tacCos = Tac.newInstance( "Qos::Cos" )
tacDscp = Tac.newInstance( "Qos::Dscp" )
tacExp = Tac.newInstance( "Qos::Exp" )
tacPriorityGroup = Tac.newInstance( "Qos::PriorityGroup" )
tacIntfConfig = Tac.newInstance( 'Qos::IntfConfig', '' )
tacTxQueuePriority = Tac.Type( 'Qos::TxQueuePriority' )
tacPercent = Tac.Type( 'Qos::Percent' )
tacShapeRate = Tac.Type( 'Qos::ShapeRate' )
tacShapeRateVal = Tac.Type( 'Qos::ShapeRateVal' )
tacShapeRateUnit = Tac.Type( 'Qos::ShapeRateUnit' )
tacGuaranteedBw = Tac.Type( 'Qos::GuaranteedBw' )
tacGuaranteedBwVal = Tac.Type( 'Qos::GuaranteedBwVal' )
tacGuaranteedBwUnit = Tac.Type( 'Qos::GuaranteedBwUnit' )
tacBurstVal = Tac.Type( 'Qos::BurstVal' )
tacBurstUnit = Tac.Type( 'Qos::BurstUnit' )
tacTxQueueId = Tac.Type( 'Qos::TxQueueId' )
tacTxQueue = Tac.Value( 'Qos::TxQueue' )
tacTxQueueConfig = Tac.newInstance( 'Qos::TxQueueConfig', tacTxQueue,
                                    tacTxQueuePriority.priorityInvalid,
                                    tacPercent.invalid, tacShapeRate(), 
                                    tacGuaranteedBw() )
tacQueueType = Tac.Type( 'Qos::QueueType' )
tacEcnDelayThresholdUnit = Tac.Type( 'Qos::EcnDelayThresholdUnit' )
tacEcnDelayThreshold = Tac.Value( 'Qos::EcnDelayThreshold' )

tacActionRateType = Tac.Type( "Qos::ActionRateType" )
tacActionRateTypePps = Tac.Type( "Qos::ActionRateTypePps" )
tacActionRateTypeKbps = Tac.Type( "Qos::ActionRateTypeKbps" )
tacMatchOption = Tac.Type( "Qos::ClassMapMatchOption" )
tacClassMapMatchBuiltIn = Tac.Type( "Qos::ClassMapMatchBuiltIn" )
tacClassMapCpStaticType = Tac.Type( "Qos::ClassMapCpStaticType" )
tacClassMapType = Tac.Type( "Qos::MapType" )
tacClassMapCpType = Tac.Type( "Qos::ClassMapCpType" )
tacPolicyMapType = Tac.Type( "Qos::MapType" )
tacPMapNm = Tac.Value( "Qos::PolicyMapNames" )
tacCMapNm = Tac.Value( "Qos::ClassMapNames" )
tacClassMapBuiltIn = Tac.Value( "Qos::BuiltInClassMapNames" )
tacActionType = Tac.Type( "Qos::ActionType" )
tacPMapHwPrgmStatus = Tac.Type( "Qos::PolicyMapHwPrgmStatus" )
tacRateUnit = Tac.Type( "Qos::RateUnit" )
tacDirection = Tac.Type( "Qos::Direction" )
tacRewriteEnableMode = Tac.Type( "Qos::RewriteEnableMode" )
tacQueueThreshold = Tac.Type( "Qos::QueueThreshold" )
tacQueueThresholdUnit = Tac.Type( "Qos::QueueThresholdUnit" )
tacHwProgrammingStatus = Tac.Type( "Qos::HwProgrammingStatus" )
tacFeatureName = Tac.Type( "Qos::FeatureName" )
tacDscpRewriteMapName = Tac.Type( "Qos::DscpRewriteMapName" )
tacPfcWatchdogAction = Tac.Type( "Pfc::WatchdogAction" )
tacCosToTcProfileName = Tac.Type( "Qos::CosToTcProfileName" )
tacTcDpPair = Tac.Type( "Qos::TcDpPair" )
tacTcToCosMapName = Tac.Type( "Qos::TcToCosMapName" )
tacLatencyThreshold = Tac.Type( 'Qos::LatencyThreshold' )
tacPolicerType = Tac.Type( 'InterfacePolicing::PolicerType' )
tacDscpToTcMapName = Tac.Type( "Qos::DscpToTcMapName" )
