# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, os

class ReadOnly( object ):
   def __init__( self, obj ):
      self.__dict__[ '_obj' ] = obj

   def __getattr__( self, attr ):
      return getattr( self._obj, attr )

   def __setattr__( self, attr, *args ):
      raise AttributeError, attr

   __delattr__ = __setattr__

def productAttributes():
   attributes = Tac.singleton( "ProductAttribute::ProductAttributes" )
   return ReadOnly( attributes )

def attributesForProduct( product ):
   os.environ[ 'PRODUCT' ] = product
   return Tac.newInstance( "ProductAttribute::ProductAttributes",
         "ProductAttributes" )
