#!/usr/bin/env python
# Copyright (c) 2007-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.


# Refer to the DS460S Pmbus commands implementation documents.
# DS460S-002/DS460S-3-003 PSU Pmbus Commands Implementation List 
# ( Rev. 1F, James L. David / 1APRIL2012 )
# DS460S-3/DS460S-3-001 PSU Pmbus Commands Implementation List
# ( Rev. AB, James L. David / 1FEBRUARY2013 )
ds460ValidRegisterValues = {
      "STATUS_WORD" : [  0x0c01,   # Not in spec - occurs when fan is
                                   # manually jammed.
                         0x0002,   # Intermittent CML faults seen on supplies
                                   # with serial numbers starting with K19.
                                   # See BUG56106.
                         0x2843,   # CML faults may also occur during power loss.
                         0x0000, 0x0004, 0x0040, 0x0044, 
                         0x0844, 0x0c41, 0x2000, 0x2841, 
                         0x4810, 0x4850, 0x8000, 0x8860, 
                         0xc850 ],
      "STATUS_IOUT" : [ 0x00, 0x80 ],
      "STATUS_VOUT" : [ 0x00, 0x20, 0x40, 0x80 ],
      "STATUS_TEMP" : [ 0x00, 0x40, 0x80, 0xc0,],
      "STATUS_FANS_1_2" : [ 0x88, # Not in spec - occurs when fan is
                                  # manually jammed.
                            0x00, 0x08, 0x80 ],
      "STATUS_INPUT" : [ 0x00, 0x08, 0x20, 0x40 ] }

ds2900PowerLossValues = [ 0x0840, 0x0800 ]
ds3000PowerLossValues = [ 0x0840, 0x0800 ]
dsPedPowerLossValues = [ 0x0840, 0x0800 ]
lassenPowerLossValues = [ 0x0840, 0x0800 ]

class Rev11Commands( object ):

   # Header Commands

   pmbusRevision = 0x98

   manufacturerId = 0x99
   manufacturerModel = 0x9A
   manufacturerVersion = 0x9B
   manufactureLocation = 0x9C
   manufactureDate = 0x9D
   manufacturerSerialNumber = 0x9E

   # Capability Commands

   memoryPage = 0x00
   clearAllFaults = 0x03
   queryCommand = 0x1A
   outputVoltageMode = 0x20
   directModeCoefficients = 0x30

   # Config / Status Registers

   writeProtect = 0x10

   statusClearFaults = 0x03

   statusWord = 0x79
   statusVoltageOut = 0x7A
   statusCurrentOut = 0x7B
   statusInput = 0x7C
   statusTemperature = 0x7D
   statusCommsLogicMemory = 0x7E
   statusOther = 0x7F
   statusManufacturer = 0x80
   statusFans_1_2 = 0x81
   statusFans_3_4 = 0x82

   tempSensorStatus = { 1 : 0x8D,
                        2 : 0x8E,
                        3 : 0x8F }

   fanSpeedSensor = { 1 : 0x90,
                      2 : 0x91,
                      3 : 0x92,
                      4 : 0x93 }
   
   inputVoltage = 0x88
   inputCurrent = 0x89
   outputVoltage = 0x8B
   outputCurrent = 0x8C
   inputPower = 0x97
   outputPower = 0x96

   fanConfig_1_2 = 0x3A
   fanConfig_3_4 = 0x3D

   fanSpeedControl = { 1 : 0x3B,
                       2 : 0x3C,
                       3 : 0x3E,
                       4 : 0x3F }

   overTemperatureFaultLimit = 0x4f
   overTemperatureWarnLimit = 0x51

   manufacturerVoltageInMin = 0xA0
   manufacturerVoltageInMax = 0xA1
   manufacturerCurrentInMax = 0xA2
   manufacturerPowerInMax = 0xA3
   manufacturerVoltageOutMin = 0xA4
   manufacturerVoltageOutMax = 0xA5
   manufacturerCurrentOutMax = 0xA6
   manufacturerPowerOutMax = 0xA7
   manufacturerTemperatureMax = 0xA8
   manufacturerTemperatureMin = 0xA9

   fanOperation = 0xD3
