#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import SharedMem

# Python helper for Routing::Pim::SparseMode::Smash::Status::mountInDependencyOrder()

def mountInDependencyOrder( em, path, mode, status=None ):
   eType = Tac.Type( "Routing::Pim::SparseMode::Smash::Status" )
   eType.mountInDependencyOrder( em.cEntityManager(), path, mode, status )
   # NOTE: For some reason, the Python breadth tests complain about the return value
   # of the above line being const, so we ignore it and retrieving the created entity
   # using SmashMount instead.
   return SharedMem.entityManager( sysdbEm=em ).getTacEntity( path )
