#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import SharedMem

# Python helper for Routing::Pim::Bidir::Smash::Status::mountInDependencyOrder()

def mountInDependencyOrder( em, path, mode ):
   eType = Tac.Type( "Routing::Pim::Bidir::Smash::Status" )
   eType.mountInDependencyOrder( em.cEntityManager(), path, mode )
   # NOTE: For some reason, Python breadth tests sometimes complain about the return
   # value of the above line being const, so we ignore it and retrieving the created
   # entity using SmashMount instead.
   return SharedMem.entityManager( sysdbEm=em ).getTacEntity( path )
