#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.


import Tac
import Tracing
import Cell

__defaultTraceHandle__ = Tracing.Handle( 'PbrCli' )
t0 = Tracing.trace0

pbrRootNode = 'pbr'
pbrCellRootNode = 'cell/%d/pbr' % Cell.cellId()
aclRootNode = 'acl'
configNode = 'config'
statusNode = 'status'
statusRequestDirNode = 'statusRequest'
pbrConfigPath = pbrRootNode + '/input/pmap/cli'
pbrConfigType = 'Pbr::PbrConfig'
pbrStatusRequestDirPath = pbrRootNode + '/' + statusRequestDirNode
pbrStatusRequestDirType = 'PolicyMap::PolicyMapStatusRequestDir'
pbrStatusPath = pbrCellRootNode + '/' + statusNode
pbrStatusType = 'Tac::Dir'
pbrHwStatusPath = pbrRootNode + '/hardware/status/global'
pbrHwStatusType = 'Pbr::HwStatus'
aclConfigPath = aclRootNode + '/' + configNode
aclConfigType = 'Acl::Input::Config'
aclStatusPath = aclRootNode + '/' + statusNode + '/' + 'all'
aclStatusType = 'Acl::Status'
lagStatusPath = 'interface/status/eth/lag'
lagStatusType = 'Interface::EthLagIntfStatusDir'
pbrPmapClassActionType = 'PolicyMap::ClassAction'
pmapSubConfigType = 'PolicyMap::PolicyMapSubConfig'
allIntfStatusPath = 'interface/status/all'
allIntfStatusType = 'Interface::AllIntfStatusDir'

tacActionType = Tac.Type( 'PolicyMap::ActionType' )
actFwdAction = tacActionType.fwdAction
actSetDscp = tacActionType.setDscp
tacDscp = Tac.newInstance( 'PolicyMap::Dscp' )
actSetTtl = tacActionType.setTtl
tacTtl = Tac.newInstance( 'Pbr::Ttl' )

tacPbrActionType = Tac.Type( 'Pbr::PbrActionType' )
tacPbrActionNone = tacPbrActionType.noAction
tacPbrActionDrop = tacPbrActionType.dropAction
tacPbrActionNextHop = tacPbrActionType.nexthopAction
tacPbrActionNextHopGroup = tacPbrActionType.nexthopGroupAction
tacPbrActionSetDscp = Tac.Type( 'PolicyMap::SetDscpAction' )
tacPbrFwdAction = Tac.Type( 'Pbr::PbrFwdAction' )
tacPbrTtlAction = Tac.Type( 'Pbr::PbrTtlAction' )

tacPbrClassMapStatus = Tac.Type( 'Pbr::PbrClassMapStatus' )

pbrMaxAcls = 1024
pbrMaxRules = 8192
pbrMaxSequence = 0xFFFFFFFF
pbrDefaultSeqInc = 10

def nhActionStrToEnum( actionStr ):
   if actionStr == 'fwdAction':
      return actFwdAction
   elif actionStr == 'dscp':
      return actSetDscp
   else:
      return None
