#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

CVX_OPENSTACK_INVALID_NETWORK_VLAN = None
Logging.logD( id="CVX_OPENSTACK_INVALID_NETWORK_VLAN",
              severity=Logging.logWarning,
              format="OpenStack tried to allocate VLAN %d to network %s from "
              "outside the region's VLAN assignment",
              explanation="When using the arista VLAN type driver, only VLANs from "
              "within the assigned VLAN pool may be allocated to OpenStack "
              "networks.",
              recommendedAction="If you do not wish to allocate this VLAN to an "
              "OpenStack network, no action is required. If you would like to "
              "allow OpenStack to provision this VLAN, then either use the default "
              "VLAN type driver or modify this region's VLAN assignment." )
