#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def coalesceList( numberList ):
   ''' Coalece's numbers in the list. 
       If the list contains 1, 2, 3, 10, 25, 26, 50, this method returns a
       string of the form 1-3, 10, 25-36, 50
   '''
   if len( numberList ) == 1:
      return str( numberList[ 0 ] )
   if len( numberList ) == 0:
      return ''

   coalecedList = ''
   start = numberList[ 0 ]
   prev = numberList[ 0 ]
   for num in numberList[ 1 : ]:
      if num == prev + 1:
         prev = num
      else:
         if prev != num and start != prev:
            coalecedList += '%d-%d, ' % ( start, prev )
         else:
            coalecedList += '%d, ' % prev
         start = num
         prev = num

   if start != prev:
      coalecedList += '%d-%d' % ( start, prev )
   else:
      # Add the last element if it's previous element isn't an integer 1 less than it
      coalecedList += '%d' % ( numberList[ -1 ] )

   return coalecedList
