# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import glob
import os
import re

class OpenConfigProfile( object ):

   def __init__( self, fileName ):
      self.fileName = fileName
      self.profileSections = self.parseConfigProfile( fileName )

   def parseConfigProfile( self, fileName ):
      profileSections = {}
      header = None
      with open( self.fileName, 'r' ) as f:
         for line in f:
            matcher = re.match( r"\[(.+)\]", line )
            if matcher:
               header = matcher.group( 1 ).strip()
               profileSections[ header ] = []
            else:
               if line.strip() and header:
                  profileSections[ header ].append( line.strip() )
      return profileSections 

class OpenConfigProfileLoader( object ):
   DEFAULT_PROFILE_PATH = "/usr/lib/OpenConfigProfiles"

   def loadProfiles( self, path=DEFAULT_PROFILE_PATH ):
      # If the path is a file, load the file.  If it is a directory, load files there
      if os.path.isdir( path ):
         # Add the trailing '/' if it doesn't exist
         path = path + "/"  if path[ -1 ] != "/"  else path
         fileList = glob.glob( path + "*" )
      else:
         fileList = glob.glob( path )

      for fileName in fileList:
         profile = OpenConfigProfile( fileName )
         if profile:
            yield profile.profileSections
