# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet.NsLib, IpUtils, Tac
from IpLibConsts import DEFAULT_VRF

def localServer():
   return '127.127.1.0'

# How many seconds to check if a server has been reached
serverReachCheckTimeout = 25

# Authentication values
authModeNone = Tac.Type( "Ntp::AuthenticationMode" ).authModeNone
authModeAll = Tac.Type( "Ntp::AuthenticationMode" ).authModeAll
authModeServers = Tac.Type( "Ntp::AuthenticationMode" ).authModeServers

def compareVrfAndHost( vrfAndHost1, vrfAndHost2 ):
   """ Compares tuples including VRF name and IP address or hostname strings. 
   """

   if vrfAndHost1.vrf < vrfAndHost2.vrf:
      return -1
   elif vrfAndHost1.vrf > vrfAndHost2.vrf:
      return 1
   # VRFs are the same
   return IpUtils.compareIpAddrOrHostname( vrfAndHost1.ipOrHost,
                                           vrfAndHost2.ipOrHost )

def vrfInUse( ntpConfig, defaultToNone=False ):
   for server in ntpConfig.server.itervalues():
      # return the VRF used by the first server (they should all be the same)
      return server.vrf
   if defaultToNone:
      return None
   return DEFAULT_VRF

def nsInUse( ntpConfig, allVrfStatusLocal ):
   vrf = vrfInUse( ntpConfig )
   if vrf != DEFAULT_VRF:
      try:
         return allVrfStatusLocal.vrf[ vrf ].networkNamespace
      except KeyError:
         return None
   return Arnet.NsLib.DEFAULT_NS

class NetNsError( Exception ):
   def __str__( self ):
      return Exception.__str__( self )

def runMaybeInNetNs( ntpConfig, allVrfStatus, execCmd, **kwargs ):
   """This is a wrapper around Arnet.NsLib.runMaybeInNetNs() that catches a few
      conditions that are considered legal for Ntp, namely:
      - Ntp::Config referencing a VRF not present in Ip::AllVrfStatus
      - Ip::AllVrfStatus referencing a namespace that doesn't exist"""
   netNs = nsInUse( ntpConfig, allVrfStatus )
   if not netNs:
      raise NetNsError
   try:
      return Arnet.NsLib.runMaybeInNetNs( netNs, execCmd, **kwargs )
   except Tac.SystemCommandError, e:
      if e.error == 255:
         errMsg1 = 'seting the network namespace failed: Invalid argument'
         errMsg2 = 'Cannot open network namespace: No such file or directory'
         if errMsg1 in e.output or errMsg2 in e.output:
            raise NetNsError
      raise
