# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from NexthopGroupConsts import (
      nexthopGroupTypes,
      nexthopGroupTokenToTacType,
)

def nexthopGroupCliString( nexthopGroupType ):
   """Converts Enum nexthop-group types to their equivalent string type. For
   example, Enum type "ipInIp" has a string type of "ip-in-ip". "gre" and
   "mpls" both have the same Enum type and string type, so they do not need
   a conversion."""
   return nexthopGroupTypes.get( nexthopGroupType, nexthopGroupType )

def nexthopGroupCliStringToTacType( nexthopGroupCliToken ):
   return nexthopGroupTokenToTacType[ nexthopGroupCliToken ]
