# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import os
from IpLibConsts import DEFAULT_VRF

def netnsNameWithUniqueId( netnsName ):
   # Return a netnsName with unique ID that can be used by Xinetd to indicate
   # a new networkspace from previous generation due to delete-and-create.
   # We just use the mtime of the netns file. Python 2.x converts the high-precision
   # timestamp to a float number, but it's good enough.
   #
   # Note nsutil's netnsRunPath/setnsByName() will ignore strings after '/@' inside
   # the name.
   if netnsName and netnsName != DEFAULT_VRF:
      try:
         st = os.stat( "/var/run/netns/%s" % netnsName )
         return "%s/@%s" % ( netnsName, st.st_mtime )
      except OSError:
         pass
   return netnsName
