#!/usr/bin/env python2.7
#
# Copyright (c) 2016-2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
#
# pylint: disable-msg=W0212

import sys
import types
import Tac
from PyClient import PyClient
from ControllerdbEntityManager import Controllerdb
from MssPolicyMonitor import Lib


def pyClientSysdb():
   return PyClient('ar', 'Sysdb').agentRoot()

def devMode():
   runOnSwitch()

def runOnSwitch():
   controllerConfig = pyClientSysdb()['controller']['config']
   print 'Setting controller/config.runOnPhysicalSwitch=True'
   controllerConfig.runOnPhysicalSwitch = True


def clearMssL3():
   print 'Clearing MssL3 ServiceDeviceConfig and PolicySourceConfig Sysdb entities'
   sysdb = pyClientSysdb()
   sdSrcCfg = sysdb['mssl3']['serviceDeviceSourceConfig']['spm']
   sdSrcCfg.serviceDevice.clear()
   pSrcCfg = sysdb['mssl3']['policySourceConfig']['spm']
   pSrcCfg.policySet.clear()


def dumpMssL3():
   sysdb = pyClientSysdb()
   mssL3Status = sysdb['mssl3']['status']
   sdSrcCfg = sysdb['mssl3']['serviceDeviceSourceConfig']['spm']
   pSrcCfg = sysdb['mssl3']['policySourceConfig']['spm']
   print '\nDUMP: mssl3/status.running:', mssL3Status.running
   print '\nDUMP: mssl3/serviceDeviceSourceConfig/spm'
   for name, sd in sdSrcCfg.serviceDevice.items():
      print 'L3SvcDevice: ', name, Lib.dumpMssL3ServiceDevice( sd )
   print '\nDUMP: mssl3/policySourceConfig/spm'
   for name, ps in pSrcCfg.policySet.items():
      print 'PolicySet: ', name, Lib.dumpMssL3PolicySet( ps )


def dumpMpmConfig():
   mpmConfig = pyClientSysdb()['msspolicymonitor']['config']
   Lib.dumpSysdbObj( mpmConfig )


def dumpMpmStatus():
   mpmStatus = pyClientSysdb()['msspolicymonitor']['status']
   Lib.dumpSysdbObj( mpmStatus )


def dumpMss():
   sysdb = pyClientSysdb()
   mssStatus = sysdb['mss']['status']
   svcPolicySrcState = sysdb['mss']['servicePolicySourceState']['spm']
   svcPolicy = sysdb['mss']['servicePolicyConfig']['spm']
   svcIntf =   sysdb['mss']['serviceIntfConfig']['spm']
   print '\nDUMP: mss/status'
   Lib.dumpSysdbObj( mssStatus )
   print '\nDUMP: mss/servicePolicySourceState/spm'
   Lib.dumpSysdbObj( svcPolicySrcState )
   print '\nDUMP: mss/serviceIntfConfig/spm'
   Lib.dumpSysdbObj( svcIntf )
   print '\nDUMP: mss/servicePolicyConfig/spm'
   Lib.dumpSysdbObj( svcPolicy )


def dumpTopologyViaPyClient( sysname='ar', version=3 ):
   print 'Initializing PyClient for Controllerdb mounts at: '\
         '/ar/Controllerdb/topology/version3/global/status'
   cdb = PyClient( sysname, 'Controllerdb').agentRoot()
   if version == 2:
      topologyService = cdb['topology']['global']['status']  # version2
   elif version == 3:
      topologyService = cdb['topology']['version3']['global']['status']  # version 3
   dumpTopology( topologyService )


def dumpTopologyViaCdBEntityManager( sysname='ar', version=3 ):
   print 'ControllerdbEntityManager mounting Network Topology Service'
   # cdbEm = ControllerdbEntityManager.Local( sysname )
   cdbSock = Tac.Value('Controller::Constants').controllerdbDefaultSockname
   cdbEm = Controllerdb( sysname, controllerdbSockname_= cdbSock, mountRoot=False )
   cMg = cdbEm.mountGroup()
   cMg.mount( '', 'Tac::Dir', 'rt' )  # t=toplevel rootMount, must do this first
   if version == 2:
      print 'Using topo version 2 tac models'
      topologyService = cMg.mount('topology/global/status',
                                  'NetworkTopology::AggregatedStatus', 'r')
   elif version == 3:
      print 'Using topo version 3 tac models'
      topologyService = cMg.mount('topology/version3/global/status',
                                  'NetworkTopologyAggregatorV3::Status', 'r')
   cMg.close( blocking=True )
   dumpTopology( topologyService )


def dumpTopology( topologyService ):
   for host in topologyService.host.values():
      print '\nHost:', host.name, host.hostname
      print 'portGroup:', host.portGroup.keys()
      print 'mlagRaw:', host.mlagRaw.keys()
      print 'mlag:', host.mlag.keys()
      print 'mlagSystemId:', host.mlagSystemId
      for lp in host.logicalPort:
         if not lp.startswith('Eth') and not lp.startswith('Man'):
            print 'logicalPort:', lp
      for name, port in host.port.iteritems():
         if port.portGroup and port.portGroup.mlag:
            print 'port:', name, port.portGroup.name, port.portGroup.mlag.name
         elif port.portGroup:
            print 'port:', name, port.portGroup.name
   print 'dumpTopology complete'


####################################################################################
COMMANDS = {
   'dump': {
      'mss':      dumpMss,
      'mssl3':    dumpMssL3,
      'config':   dumpMpmConfig,
      'cfg':      dumpMpmConfig,
      'status':   dumpMpmStatus,
      'stat':     dumpMpmStatus,
      'topology': dumpTopologyViaPyClient,
      'topo':     dumpTopologyViaPyClient,
   },
   'clear': {
      'mssl3':    clearMssL3,
   },
   'dev': devMode,
   'run': runOnSwitch,
}


def printUsage():
   print '''Usage: python -m MssPMUtil ( run | clear mssl3 | enable mssl3 | dev |
                             dump ( mssl3 | mss | config | status | topology ) )
  run  allows CVX to run on a physical switch (and in an Arista developer workspace)
  dev   Arista development mode (currently = run + enable mssl3)
  clear mssl3  clears MssL3 ServiceDeviceConfig and PolicySourceConfig Sysdb entities
  enable mssl3 enables the pre-released MssL3 mode of operation  
  dump various sysdb entities
'''


def parseCommandLineArgs():
   nextParseLevel = COMMANDS
   for token in sys.argv[1:]:
      actionObject = nextParseLevel.get( token )
      # print 'processing token:', token, 'actionObject type:', type( actionObject )
      if isinstance( actionObject, dict ):
         nextParseLevel = actionObject
      elif isinstance( actionObject, types.FunctionType ):
         actionObject()
         return
      else:
         break
   printUsage()


if __name__ == '__main__':
   parseCommandLineArgs()
