# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from MsrpTypes import tacMsrpCounter

msrpCountersKeys = [ tacMsrpCounter.Advertise,
                     tacMsrpCounter.Failed, 
                     tacMsrpCounter.AdvertiseToFailed,
                     tacMsrpCounter.AdvertiseLv,
                     tacMsrpCounter.FailedLv,
                     tacMsrpCounter.AdvertiseDiscards,
                     tacMsrpCounter.FailedDiscards,
                     tacMsrpCounter.AdvertiseLvDiscards,
                     tacMsrpCounter.FailedLvDiscards,
                     tacMsrpCounter.Ready,
                     tacMsrpCounter.ReadyFailed,
                     tacMsrpCounter.AskingFailed,
                     tacMsrpCounter.ListenerLv,
                     tacMsrpCounter.ReadyDiscards,
                     tacMsrpCounter.ReadyFailedDiscards,
                     tacMsrpCounter.AskingFailedDiscards,
                     tacMsrpCounter.ListenerLvDiscards ]

countersFmt = {
      tacMsrpCounter.Advertise: 'Talker Advertise',
      tacMsrpCounter.Failed: 'Talker Failed',
      tacMsrpCounter.AdvertiseToFailed: 'Talker Advertise To Failed',
      tacMsrpCounter.Ready: 'Listener Ready',
      tacMsrpCounter.ReadyFailed: 'Listener Ready Failed',
      tacMsrpCounter.AskingFailed: 'Listener Asking Failed',
      tacMsrpCounter.AdvertiseDiscards: 'Talker Advertise Discards',
      tacMsrpCounter.FailedDiscards: 'Talker Failed Discards',
      tacMsrpCounter.ReadyDiscards: 'Listener Ready Discards',
      tacMsrpCounter.ReadyFailedDiscards: 'Listener Ready Failed Discards',
      tacMsrpCounter.AskingFailedDiscards: 'Listener Asking Failed Discards',
      tacMsrpCounter.AdvertiseLv: 'Talker Advertise Leave',
      tacMsrpCounter.FailedLv: 'Talker Failed Leave',
      tacMsrpCounter.ListenerLv: 'Listener Leave',
      tacMsrpCounter.AdvertiseLvDiscards: 'Talker Advertise Leave Discards',
      tacMsrpCounter.FailedLvDiscards: 'Talker Failed Leave Discards',
      tacMsrpCounter.ListenerLvDiscards: 'Listener Leave Discards' }

def getAttrValues( value, attrType ):
   '''Utility function to print the attributes in their logical order'''
   if type( value ) == str:
      value = eval( value )
   string = ''
   if attrType == 1 or attrType == 2:
      # Talker Advertise or Talker Failed
      attrs = ( 'streamId', 'dmac', 'vlan', 'maxFrameSize', 'maxIntervalFrames',
                'priority', 'rank', 'accumulatedLatency' )
      for attr in attrs:
         string += '%s: %s, ' % ( attr, value[ attr ] )

      if attrType == 2:
         for attr in ( 'bridgeId', 'failureCode' ):
            string += '%s: %s, ' % ( attr, value[ attr ] )

   elif attrType == 3:
      # Listener
      attrs = ( 'streamId', 'listenerEvent' )
      for attr in attrs:
         string += '%s: %s, ' % ( attr, value[ attr ] )

   elif attrType == 4:
      # Domain
      attrs = ( 'srClassId', 'srClassPriority', 'srClassVID' )
      for attr in attrs:
         string += '%s: %s, ' % ( attr, value[ attr ] )
   return string.strip().strip( ',' )

def getValueFromBytes( firstValue, lower, size ):
   value = 0
   position = 0
   for i in xrange( lower + size - 1, lower-1, -1 ):
      value += firstValue[ i ] << position
      position += 1
   return value

def getAttrs( firstValue, attrType ):
   values = {}
   if attrType == 1 or attrType == 2:
      # Talker Advertise or Talker Failed
      streamId = getValueFromBytes( firstValue, 0, 8 )
      dmacVal = '%012x' % getValueFromBytes( firstValue, 8, 6 )
      dmac = ':'.join( [ dmacVal[ i:i+2 ] for i in xrange(0, 12, 2 ) ] )
      vlan = getValueFromBytes( firstValue, 14, 2 )
      maxFrameSize = getValueFromBytes( firstValue, 16, 2 )
      maxIntervalFrames = getValueFromBytes( firstValue, 18, 2 )
      priority = getValueFromBytes( firstValue, 20, 1 )
      if priority & 1 << 4:
         rank = 1
      else:
         rank = 0
      priority >>= 5
      accumulatedLatency = getValueFromBytes( firstValue, 21, 4 )

      if attrType == 2:
         # Talker Failed
         bridgeId = getValueFromBytes( firstValue, 25, 8 )
         failureCode = getValueFromBytes( firstValue, 33, 1 )
         values = dict( streamId=streamId, dmac=dmac,
                        vlan=vlan, maxFrameSize=maxFrameSize,
                        maxIntervalFrames=maxIntervalFrames,
                        priority=priority, rank=rank,
                        accumulatedLatency=accumulatedLatency,
                        bridgeId=bridgeId, failureCode=failureCode )
      else:
         values = dict( streamId=streamId, dmac=dmac,
                        vlan=vlan, maxFrameSize=maxFrameSize,
                        maxIntervalFrames=maxIntervalFrames,
                        priority=priority, rank=rank,
                        accumulatedLatency=accumulatedLatency )

   elif attrType == 3:
      # Listener
      streamId = getValueFromBytes( firstValue, 0, 8 )
      listenerEvent = getValueFromBytes( firstValue, 8, 1 )
      values = dict( streamId=streamId,
                     listenerEvent=listenerEvent )
   elif attrType == 4:
      # Domain
      srClass = getValueFromBytes( firstValue, 0, 1 )
      srClassPrio = getValueFromBytes( firstValue, 1, 1 )
      srClassVID = getValueFromBytes( firstValue, 2, 2 )
      values = dict( srClassId=srClass,
                     srClassPriority=srClassPrio,
                     srClassVID=srClassVID )
   return values
