#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Agent
import Cell
import Tac
import SharedMem
import Smash
from Arnet.NsLib import DEFAULT_NS

AgentName = 'MplsUtilLsp'

class MplsUtilLsp( Agent.Agent ):
   def __init__( self, entityManager ):
      Agent.Agent.__init__( self, entityManager, agentName=AgentName )
      self.root_ = None
      self.allIntfStatusLocalDir_ = None
      self.timerWheel_ = None
      self.ipStatus_ = None
      self.allIntfStatusDir_ = None
      self.ip6Status_ = None
      self.kniStatus_ = None
      self.bridgingConfig_ = None
      self.mplsHwStatus_ = None
      self.routingHwRouteStatus_ = None
      self.mplsStatus_ = None
      self.isisV4SmashColl_ = None
      self.isisV6SmashColl_ = None
      self.ldpSmashColl_ = None
      self.ldpCommonLibSmashColl_ = None
      self.p2mpSmashColl_ = None
      self.p2mpCommonLibSmashColl_ = None
      self.rsvpStatus_ = None
      self.mldpOpqTable_ = None
      self.ldpStatusColl_ = None
      self.transitLfib_ = None
      self.mldpTransitLfib_ = None
      self.forwardingStatus_ = None
      self.forwarding6Status_ = None
      self.routingStatus_ = None
      self.routing6Status_ = None
      self.tiLfaTunnelTable_ = None
      self.l3Config_ = None
      self.packetTracerConfig_ = None
      self.packetTracerStatus_ = None
      self.pwLfib_ = None
      self.pwLabelBindingColl_ = None
      self.pwRcsColl_ = None
      self.bgpLuLfib_ = None
      self.bgpLuRib_ = None

   def doInit( self, entityManager ):
      mg = entityManager.mountGroup()
      self.l3Config_ = mg.mount( "l3/config", "L3::Config", "r" )
      # pylint: disable-msg=W0201

      def _onMountsComplete():
         self.fecModeStatus_ = Tac.newInstance( "Smash::Fib::FecModeStatus",
                                                "fecModeStatus" )
         self.fecModeSm_ = Tac.newInstance( "Ira::FecModeSm", self.l3Config_,
                                            self.fecModeStatus_ )
         self.fecModeRestartSm_ = Tac.newInstance( "Ira::FecModeRestartSm",
                                                   self.fecModeStatus_ )
         self.doInitStage2( entityManager )

      mg.close( _onMountsComplete )

   def doInitStage2( self, entityManager ):
      # pylint: disable=attribute-defined-outside-init, W0201
      mg = entityManager.mountGroup()
      Tac.Type( "Ira::IraIpStatusMounter" ).doMountEntities( mg.cMg_, True, True )
      self.ipStatus_ = mg.mount( "ip/status", "Ip::Status", "r" )
      self.ip6Status_ = mg.mount( "ip6/status", "Ip6::Status", "r" )
      self.mplsHwStatus_ = mg.mount( "routing/hardware/mpls/status",
                                     "Mpls::Hardware::Status", "rS" )
      self.routingHwRouteStatus_ = mg.mount( "routing/hardware/route/status",
                                             "Routing::Hardware::RouteStatus", "r" )
      self.bridgingConfig_ = mg.mount( "bridging/config", "Bridging::Config", "r" )
      self.rsvpStatus_ = mg.mount( "mpls/rsvp/status",
                                   "Rsvp::RsvpStatus", "rS" )
      self.mplsStatus_ = mg.mount( "mpls/status", "Mpls::Api::Status", "rS" )
      self.mplsUtilsConfig_ = mg.mount( 'mplsutils/config',
                                        'MplsUtils::Config', 'r' )
      self.mldpOpqTable_ = mg.mount( "mpls/ldp/mldpOpaqueValueTable",
                                     "Mpls::MldpOpaqueValueTable", "r" )
      self.ldpStatusColl_ = mg.mount( "mpls/ldp/ldpStatusColl",
                                      "Ldp::LdpStatusColl", "r" )
      self.packetTracerConfig_ = mg.mount( 'packettracer/config/%s' % AgentName,
                                           'PacketTracer::ClientConfig',
                                           'w' )
      self.packetTracerStatus_ = mg.mount( 'packettracer/status/%s' % AgentName,
                                           'PacketTracer::ClientStatus',
                                           'r' )
      self.packetTracerHwStatus_ = mg.mount( 'packettracer/hwstatus',
                                             'PacketTracer::HwStatus',
                                             'r' )
      self.packetTracerSwStatus_ = mg.mount( 'packettracer/swstatus',
                                             'PacketTracer::SwStatus',
                                             'r' )
      self.timerWheel_ = Tac.newInstance( "Ark::TimerWheel",
                                          Tac.activityManager.clock, 100,
                                          10 * 60 * 5, True, 1024 )
      self.schedulerRoot_ = Tac.Type( "Ark::TaskSchedulerRoot" ).\
                            findOrCreateScheduler()

      if self.fecModeStatus_.fecMode == 'fecModeUnified':
         forwardingStatusPath = "forwarding/unifiedStatus"
         forwarding6StatusPath = "forwarding6/unifiedStatus"
      else:
         forwardingStatusPath = "forwarding/status"
         forwarding6StatusPath = "forwarding6/status"

      self.allIntfStatusLocalDir_ = self.createLocalEntity(
         "AllIntfStatusLocalDir",
         "Interface::AllIntfStatusLocalDir",
         Cell.path( "interface/status/local" ) )

      self.allIntfStatusDir_ = self.createLocalEntity(
         "AllIntfStatusDir",
         "Interface::AllIntfStatusDir",
         "interface/status/all" )

      self.localEntitiesCreatedIs( True )

      shmemEm = SharedMem.entityManager( sysdbEm=entityManager )
      readerInfo = Smash.mountInfo( 'reader' )
      keyShadowInfo = Smash.mountInfo( 'keyshadow' )
      # Only default VRF is supported for now. We will need to mount kniStatus
      # per VRF when multi-VRF support exists. See BUG124566.
      # kniStatus is a keyshadow instead of reader because MplsUtils passes it to
      # Interface::IntfStatusManager which reacts to it.
      self.kniStatus_ = shmemEm.doMount( "kni/ns/%s/status" % DEFAULT_NS,
                                         "KernelNetInfo::Status", keyShadowInfo )
      self.forwardingStatus_ = shmemEm.doMount( forwardingStatusPath,
                                                "Smash::Fib::ForwardingStatus",
                                                readerInfo )
      self.forwarding6Status_ = shmemEm.doMount( forwarding6StatusPath,
                                                 "Smash::Fib6::ForwardingStatus",
                                                 readerInfo )

      self.routingStatus_ = shmemEm.doMount( "routing/status",
                                             "Smash::Fib::RouteStatus",
                                             readerInfo )
      self.routing6Status = shmemEm.doMount( "routing6/status",
                                             "Smash::Fib6::RouteStatus",
                                             readerInfo )

      self.mplsUtilsConfig_ = mg.mount( 'mplsutils/config',
                                       'MplsUtils::Config', 'r' )

      self.isisV4SmashColl_ = shmemEm.doMount( "mpls/labelBindingTables/isisV4",
                                            "CommonLibSmash::LabelBindingTable",
                                            keyShadowInfo )
      self.isisV6SmashColl_ = shmemEm.doMount( "mpls/labelBindingTables/isisV6",
                                            "CommonLibSmash::LabelBindingTable",
                                            keyShadowInfo )
      self.ldpSmashColl_ = shmemEm.doMount( "mpls/ldp/ldpBindingTables",
                                            "Ldp::LdpSmash::LdpLabelBindingTable",
                                            keyShadowInfo )
      self.ldpCommonLibSmashColl_ = shmemEm.doMount(
         "mpls/labelBindingTables/ldp", "CommonLibSmash::LabelBindingTable",
         keyShadowInfo )
      self.p2mpSmashColl_ = shmemEm.doMount( "mpls/ldp/ldpP2mpBindingTables",
                                             "Ldp::LdpSmash::LdpLabelBindingTable",
                                             keyShadowInfo )
      self.p2mpCommonLibSmashColl_ = shmemEm.doMount(
         "mpls/labelBindingTables/mldp", "CommonLibSmash::LabelBindingTable",
         keyShadowInfo )

      self.transitLfib_ = shmemEm.doMount( 'mpls/transitLfib', 'Mpls::LfibStatus',
                                           readerInfo )
      self.tiLfaTunnelTable_ = shmemEm.doMount(
         'tunnel/table/tiLfa', 'Tunnel::TunnelTable::TiLfaTunnelTable', readerInfo )
      self.mldpTransitLfib_ = shmemEm.doMount( 'mpls/protoLfibInputDir/mldp',
                                               'Mpls::LfibStatus', readerInfo )
      self.pwLfib_ = shmemEm.doMount( 'mpls/protoLfibInputDir/pseudowire',
                                      'Mpls::LfibStatus', readerInfo )
      self.pwLabelBindingColl_ = mg.mount( 'pseudowire/agent/labelBinding',
                                'Pseudowire::LabelBindingColl', 'r' )
      self.pwRcsColl_ = mg.mount( 'pseudowire/agent/remoteConnectorStatusColl',
                                  'Pseudowire::RemoteConnectorStatusColl', 'r' )
      self.bgpLuLfib_ = shmemEm.doMount( 'mpls/protoLfibInputDir/bgpLu',
                                         'Mpls::LfibStatus', readerInfo )
      self.bgpLuRib_ = shmemEm.doMount( 'tunnel/protoTunnelRib/bgpLu',
                                        'Tunnel::TunnelTable::TunnelRib',
                                        readerInfo )

      local = entityManager.root().parent
      self.root_ = None
      # pylint: disable-msg=W0201
      def _onMountsComplete():
         print ( "Mounts complete. Initializing" )
         self.root_ = local[ AgentName ].newEntity(
                                                   'MplsUtils::MplsUtilsAgentRoot',
                                                   'mplsUtilsAgentRoot' )
         self.root_.mplsUtilsRootSm = ( self.ipStatus_, self.ip6Status_,
                                        self.mplsHwStatus_, 
                                        self.mplsStatus_,
                                        self.isisV4SmashColl_,
                                        self.isisV6SmashColl_,
                                        self.ldpSmashColl_,
                                        self.ldpCommonLibSmashColl_,
                                        self.p2mpSmashColl_,
                                        self.p2mpCommonLibSmashColl_,
                                        self.mldpOpqTable_,
                                        self.ldpStatusColl_,
                                        self.transitLfib_,
                                        self.mldpTransitLfib_,
                                        self.routingHwRouteStatus_,
                                        self.forwardingStatus_,
                                        self.forwarding6Status_,
                                        self.routingStatus_,
                                        self.routing6Status_,
                                        self.tiLfaTunnelTable_,
                                        self.allIntfStatusDir_,
                                        self.allIntfStatusLocalDir_,
                                        self.kniStatus_,
                                        self.mplsUtilsConfig_,
                                        self.bridgingConfig_,
                                        self.rsvpStatus_,
                                        self.packetTracerConfig_,
                                        self.packetTracerStatus_,
                                        self.packetTracerHwStatus_,
                                        self.packetTracerSwStatus_,
                                        self.timerWheel_,
                                        self.pwLfib_,
                                        self.pwLabelBindingColl_,
                                        self.pwRcsColl_,
                                        self.bgpLuLfib_,
                                        self.bgpLuRib_,
                                        self.schedulerRoot_ )
         print "%s started" % AgentName

      mg.close( _onMountsComplete )

def main():
   container = Agent.AgentContainer( [ MplsUtilLsp ], passiveMount=True )
   container.runAgents()

if __name__ == "__main__":
   main()
